/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security.rest;

import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.nexus.repository.security.rest.ApiPrivilegeRepositoryAdminRequest;
import org.sonatype.nexus.repository.security.rest.ApiPrivilegeRepositoryContentSelectorRequest;
import org.sonatype.nexus.repository.security.rest.ApiPrivilegeRepositoryViewRequest;
import org.sonatype.nexus.repository.security.rest.RepositoryPrivilegeApiResourceDoc;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.privilege.PrivilegeDescriptor;
import org.sonatype.nexus.security.privilege.rest.ApiPrivilegeRequest;
import org.sonatype.nexus.security.privilege.rest.PrivilegeApiResourceSupport;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RepositoryPrivilegeApiResource
extends PrivilegeApiResourceSupport
implements Resource,
RepositoryPrivilegeApiResourceDoc {
    @Inject
    public RepositoryPrivilegeApiResource(SecuritySystem securitySystem, Map<String, PrivilegeDescriptor> privilegeDescriptors) {
        super(securitySystem, privilegeDescriptors);
    }

    @Override
    @POST
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:privileges:create"})
    @Path(value="repository-admin")
    public Response createPrivilege(ApiPrivilegeRepositoryAdminRequest privilege) {
        return this.doCreate("repository-admin", (ApiPrivilegeRequest)privilege);
    }

    @Override
    @PUT
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:privileges:update"})
    @Path(value="repository-admin/{privilegeName}")
    public void updatePrivilege(@PathParam(value="privilegeName") String privilegeName, ApiPrivilegeRepositoryAdminRequest privilege) {
        this.doUpdate(privilegeName, "repository-admin", (ApiPrivilegeRequest)privilege);
    }

    @Override
    @POST
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:privileges:create"})
    @Path(value="repository-view")
    public Response createPrivilege(ApiPrivilegeRepositoryViewRequest privilege) {
        return this.doCreate("repository-view", (ApiPrivilegeRequest)privilege);
    }

    @Override
    @PUT
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:privileges:update"})
    @Path(value="repository-view/{privilegeName}")
    public void updatePrivilege(@PathParam(value="privilegeName") String privilegeName, ApiPrivilegeRepositoryViewRequest privilege) {
        this.doUpdate(privilegeName, "repository-view", (ApiPrivilegeRequest)privilege);
    }

    @Override
    @POST
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:privileges:create"})
    @Path(value="repository-content-selector")
    public Response createPrivilege(ApiPrivilegeRepositoryContentSelectorRequest privilege) {
        return this.doCreate("repository-content-selector", (ApiPrivilegeRequest)privilege);
    }

    @Override
    @PUT
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:privileges:update"})
    @Path(value="repository-content-selector/{privilegeName}")
    public void updatePrivilege(@PathParam(value="privilegeName") String privilegeName, ApiPrivilegeRepositoryContentSelectorRequest privilege) {
        this.doUpdate(privilegeName, "repository-content-selector", (ApiPrivilegeRequest)privilege);
    }
}

