/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security.rest;

import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import javax.validation.constraints.NotBlank;
import org.sonatype.nexus.security.privilege.Privilege;
import org.sonatype.nexus.security.privilege.rest.ApiPrivilegeWithActions;
import org.sonatype.nexus.security.privilege.rest.PrivilegeAction;

public abstract class ApiPrivilegeWithRepository
extends ApiPrivilegeWithActions {
    public static final String FORMAT_KEY = "format";
    public static final String REPOSITORY_KEY = "repository";
    @NotBlank
    @ApiModelProperty(value="The repository format (i.e 'nuget', 'npm') this privilege will grant access to (or * for all).")
    private String format;
    @NotBlank
    @ApiModelProperty(value="The name of the repository this privilege will grant access to (or * for all).")
    private String repository;

    public ApiPrivilegeWithRepository(String privilegeType) {
        super(privilegeType);
    }

    public ApiPrivilegeWithRepository(String type, String name, String description, boolean readOnly, String format, String repository, Collection<PrivilegeAction> actions) {
        super(type, name, description, readOnly, actions);
        this.format = format;
        this.repository = repository;
    }

    public ApiPrivilegeWithRepository(Privilege privilege) {
        super(privilege);
        this.format = privilege.getPrivilegeProperty(FORMAT_KEY);
        this.repository = privilege.getPrivilegeProperty(REPOSITORY_KEY);
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getFormat() {
        return this.format;
    }

    protected Privilege doAsPrivilege(Privilege privilege) {
        super.doAsPrivilege(privilege);
        privilege.addProperty(FORMAT_KEY, this.getFormat());
        privilege.addProperty(REPOSITORY_KEY, this.getRepository());
        return privilege;
    }

    protected String doAsActionString() {
        return this.toBreadActionString();
    }
}

