/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security.rest;

import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import javax.validation.constraints.NotBlank;
import org.sonatype.nexus.repository.security.rest.ApiPrivilegeWithRepositoryRequest;
import org.sonatype.nexus.security.privilege.Privilege;
import org.sonatype.nexus.security.privilege.rest.PrivilegeAction;

public class ApiPrivilegeRepositoryContentSelectorRequest
extends ApiPrivilegeWithRepositoryRequest {
    public static final String CSEL_KEY = "contentSelector";
    @NotBlank
    @ApiModelProperty(value="The name of a content selector that will be used to grant access to content via this privilege.")
    private String contentSelector;

    private ApiPrivilegeRepositoryContentSelectorRequest() {
    }

    public ApiPrivilegeRepositoryContentSelectorRequest(String name, String description, String format, String repository, String contentSelector, Collection<PrivilegeAction> actions) {
        super(name, description, format, repository, actions);
        this.contentSelector = contentSelector;
    }

    public ApiPrivilegeRepositoryContentSelectorRequest(Privilege privilege) {
        super(privilege);
        this.contentSelector = privilege.getPrivilegeProperty(CSEL_KEY);
    }

    public void setContentSelector(String contentSelector) {
        this.contentSelector = contentSelector;
    }

    public String getContentSelector() {
        return this.contentSelector;
    }

    @Override
    protected Privilege doAsPrivilege(Privilege privilege) {
        super.doAsPrivilege(privilege);
        privilege.setType("repository-content-selector");
        privilege.addProperty(CSEL_KEY, this.contentSelector);
        return privilege;
    }
}

