/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security.rest;

import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import javax.validation.constraints.NotBlank;
import org.sonatype.nexus.repository.security.rest.ApiPrivilegeWithRepository;
import org.sonatype.nexus.security.privilege.Privilege;
import org.sonatype.nexus.security.privilege.rest.PrivilegeAction;

public class ApiPrivilegeRepositoryContentSelector
extends ApiPrivilegeWithRepository {
    public static final String CSEL_KEY = "contentSelector";
    @NotBlank
    @ApiModelProperty(value="The name of a content selector that will be used to grant access to content via this privilege.")
    private String contentSelector;

    private ApiPrivilegeRepositoryContentSelector() {
        super("repository-content-selector");
    }

    public ApiPrivilegeRepositoryContentSelector(String name, String description, boolean readOnly, String format, String repository, String contentSelector, Collection<PrivilegeAction> actions) {
        super("repository-content-selector", name, description, readOnly, format, repository, actions);
        this.contentSelector = contentSelector;
    }

    public ApiPrivilegeRepositoryContentSelector(Privilege privilege) {
        super(privilege);
        this.contentSelector = privilege.getPrivilegeProperty(CSEL_KEY);
    }

    public void setContentSelector(String contentSelector) {
        this.contentSelector = contentSelector;
    }

    public String getContentSelector() {
        return this.contentSelector;
    }

    @Override
    protected Privilege doAsPrivilege(Privilege privilege) {
        super.doAsPrivilege(privilege);
        privilege.addProperty(CSEL_KEY, this.contentSelector);
        return privilege;
    }
}

