/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;

@Named
@Singleton
public class VariableResolverAdapterManagerImpl
extends ComponentSupport
implements VariableResolverAdapterManager {
    @VisibleForTesting
    static final String DEFAULT_ADAPTER_NAME = "simple";
    private final VariableResolverAdapter defaultAdapter;
    private final Map<String, VariableResolverAdapter> adaptersByFormat;

    @Inject
    public VariableResolverAdapterManagerImpl(Map<String, VariableResolverAdapter> adaptersByFormat) {
        this.adaptersByFormat = (Map)Preconditions.checkNotNull(adaptersByFormat);
        this.defaultAdapter = (VariableResolverAdapter)Preconditions.checkNotNull((Object)adaptersByFormat.get(DEFAULT_ADAPTER_NAME));
    }

    public VariableResolverAdapter get(String format) {
        return this.adaptersByFormat.getOrDefault(format, this.defaultAdapter);
    }
}

