/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security.internal;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.realm.Realm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.security.realm.RealmManager;

@Named(value="Default Admin Credentials")
@Singleton
public class DefaultUserHealthCheck
extends HealthCheck {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserHealthCheck.class);
    static final String ERROR_MESSAGE = "The default admin credentials have not been changed. It is strongly recommended that the default admin password be changed.";
    private final RealmManager realmManager;
    private final RealmSecurityManager realmSecurityManager;

    @Inject
    public DefaultUserHealthCheck(RealmManager realmManager, RealmSecurityManager realmSecurityManager) {
        this.realmManager = (RealmManager)Preconditions.checkNotNull((Object)realmManager);
        this.realmSecurityManager = (RealmSecurityManager)Preconditions.checkNotNull((Object)realmSecurityManager);
    }

    protected HealthCheck.Result check() {
        if (!this.realmManager.isRealmEnabled("NexusAuthenticatingRealm")) {
            return HealthCheck.Result.healthy();
        }
        Optional<Realm> realm = this.realmSecurityManager.getRealms().stream().filter(r -> r.getName().equals("NexusAuthenticatingRealm")).findFirst();
        try {
            if (realm.map(r -> r.getAuthenticationInfo((AuthenticationToken)new UsernamePasswordToken("admin", "admin123"))).isPresent()) {
                return HealthCheck.Result.unhealthy((String)ERROR_MESSAGE);
            }
        }
        catch (AuthenticationException e) {
            log.trace("Unable to locate admin/admin123 user", (Throwable)e);
        }
        return HealthCheck.Result.healthy();
    }
}

