/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security;

import com.google.common.base.Preconditions;
import org.apache.shiro.authz.AuthorizationException;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.RepositoryFormatSecurityContributor;
import org.sonatype.nexus.repository.security.SecurityFacet;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.selector.VariableSource;

public abstract class SecurityFacetSupport
extends FacetSupport
implements SecurityFacet {
    private final RepositoryFormatSecurityContributor securityContributor;
    private final VariableResolverAdapter variableResolverAdapter;
    private final ContentPermissionChecker contentPermissionChecker;

    public SecurityFacetSupport(RepositoryFormatSecurityContributor securityContributor, VariableResolverAdapter variableResolverAdapter, ContentPermissionChecker contentPermissionChecker) {
        this.securityContributor = (RepositoryFormatSecurityContributor)((Object)Preconditions.checkNotNull((Object)((Object)securityContributor)));
        this.variableResolverAdapter = (VariableResolverAdapter)Preconditions.checkNotNull((Object)variableResolverAdapter);
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
    }

    protected void doInit(Configuration configuration) throws Exception {
        this.securityContributor.add(this.getRepository());
    }

    protected void doDelete() throws Exception {
        this.securityContributor.remove(this.getRepository());
    }

    @Override
    public void ensurePermitted(Request request) {
        Preconditions.checkNotNull((Object)request);
        String action = this.action(request);
        Repository repo = this.getRepository();
        VariableSource variableSource = this.variableResolverAdapter.fromRequest(request, this.getRepository());
        if (!this.contentPermissionChecker.isPermitted(repo.getName(), repo.getFormat().getValue(), action, variableSource)) {
            throw new AuthorizationException();
        }
    }

    protected String action(Request request) {
        switch (request.getAction()) {
            case "OPTIONS": 
            case "GET": 
            case "HEAD": 
            case "TRACE": {
                return "read";
            }
            case "POST": 
            case "MKCOL": 
            case "PATCH": {
                return "add";
            }
            case "PUT": {
                return "edit";
            }
            case "DELETE": {
                return "delete";
            }
        }
        throw new RuntimeException("Unsupported action: " + request.getAction());
    }
}

