/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.ws.rs.core.Response;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.security.rest.ApiPrivilegeWithRepository;
import org.sonatype.nexus.repository.security.rest.ApiPrivilegeWithRepositoryRequest;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.security.privilege.PrivilegeDescriptorSupport;
import org.sonatype.nexus.security.privilege.rest.ApiPrivilegeWithActionsRequest;
import org.sonatype.nexus.security.privilege.rest.PrivilegeAction;

public abstract class RepositoryPrivilegeDescriptorSupport<T extends ApiPrivilegeWithRepository, Y extends ApiPrivilegeWithRepositoryRequest>
extends PrivilegeDescriptorSupport<T, Y> {
    public static final String INVALID_REPOSITORY = "\"Invalid repository '%s' supplied.\"";
    public static final String INVALID_FORMAT_FOR_REPOSITORY = "\"Invalid format '%s' supplied for repository '%s'.\"";
    public static final String INVALID_FORMAT = "\"Invalid format '%s' supplied.\"";
    private final RepositoryManager repositoryManager;
    private final List<Format> formats;

    public RepositoryPrivilegeDescriptorSupport(String type, RepositoryManager repositoryManager, List<Format> formats) {
        super(type);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.formats = (List)Preconditions.checkNotNull(formats);
    }

    public void validate(Y apiPrivilege) {
        this.validateActions((ApiPrivilegeWithActionsRequest)apiPrivilege, PrivilegeAction.getBreadActions());
        this.validateRepositoryAndFormat(apiPrivilege);
    }

    protected void validateRepositoryAndFormat(Y apiPrivilege) {
        String repo = ((ApiPrivilegeWithRepositoryRequest)((Object)apiPrivilege)).getRepository();
        String format = ((ApiPrivilegeWithRepositoryRequest)((Object)apiPrivilege)).getFormat();
        Repository repository = this.repositoryManager.get(repo);
        if (!"*".equals(repo) && repository == null) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)String.format(INVALID_REPOSITORY, ((ApiPrivilegeWithRepositoryRequest)((Object)apiPrivilege)).getRepository()), "application/json");
        }
        if (!"*".equals(format) && repository != null && !repository.getFormat().getValue().equals(format)) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)String.format(INVALID_FORMAT_FOR_REPOSITORY, ((ApiPrivilegeWithRepositoryRequest)((Object)apiPrivilege)).getFormat(), ((ApiPrivilegeWithRepositoryRequest)((Object)apiPrivilege)).getRepository()), "application/json");
        }
        if (!"*".equals(format) && this.formats.stream().noneMatch(f -> f.getValue().equals(format))) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)String.format(INVALID_FORMAT, ((ApiPrivilegeWithRepositoryRequest)((Object)apiPrivilege)).getFormat()), "application/json");
        }
    }
}

