/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.subject.Subject;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Recipe;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.security.RepositoryAdminPermission;
import org.sonatype.nexus.repository.security.RepositoryContentSelectorPermission;
import org.sonatype.nexus.repository.security.RepositoryViewPermission;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorManager;

@Named
@Singleton
public class RepositoryPermissionChecker
extends ComponentSupport {
    private final SecurityHelper securityHelper;
    private final SelectorManager selectorManager;
    private final Map<String, Recipe> recipes;

    @Inject
    public RepositoryPermissionChecker(SecurityHelper securityHelper, SelectorManager selectorManager, Map<String, Recipe> recipes) {
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.selectorManager = (SelectorManager)Preconditions.checkNotNull((Object)selectorManager);
        this.recipes = (Map)Preconditions.checkNotNull(recipes);
    }

    public boolean userCanReadOrBrowse(Repository repository) {
        return this.userHasRepositoryViewPermissionTo(repository, "browse", "read") || this.userHasAnyContentSelectorAccessTo(repository, "browse", "read");
    }

    public boolean userCanDeleteInRepository(Repository repository) {
        return this.userHasRepositoryViewPermissionTo("delete", repository) || this.userHasAnyContentSelectorAccessTo(repository, "delete");
    }

    private boolean userHasRepositoryViewPermissionTo(Repository repository, String ... actions) {
        return this.securityHelper.anyPermitted(RepositoryPermissionChecker.permissionsFor(repository, actions));
    }

    private boolean userHasRepositoryViewPermissionTo(String action, Repository repository) {
        return this.securityHelper.anyPermitted(new Permission[]{new RepositoryViewPermission(repository, action)});
    }

    private static Permission[] permissionsFor(Repository repository, String ... actions) {
        return (Permission[])Arrays.stream(actions).map(action -> new RepositoryViewPermission(repository, (String)action)).toArray(Permission[]::new);
    }

    public List<Repository> userCanBrowseRepositories(Repository ... repositories) {
        Subject subject = this.securityHelper.subject();
        ArrayList<Repository> filteredRepositories = new ArrayList<Repository>(Arrays.asList(repositories));
        List<Repository> permittedRepositories = this.userHasPermission(r -> new RepositoryViewPermission((Repository)r, "browse"), repositories);
        filteredRepositories.removeAll(permittedRepositories);
        if (!filteredRepositories.isEmpty()) {
            permittedRepositories.addAll(this.subjectHasAnyContentSelectorAccessTo(subject, filteredRepositories));
        }
        return permittedRepositories;
    }

    public List<Configuration> userCanBrowseRepositories(Configuration ... repositories) {
        Subject subject = this.securityHelper.subject();
        ArrayList<Configuration> filteredRepositories = new ArrayList<Configuration>(Arrays.asList(repositories));
        List<Configuration> permittedRepositories = this.userHasPermission(c -> new RepositoryViewPermission(this.toFormat((Configuration)c), c.getRepositoryName(), "browse"), repositories);
        filteredRepositories.removeAll(permittedRepositories);
        if (!filteredRepositories.isEmpty()) {
            permittedRepositories.addAll(this.subjectHasAnyContentSelectorAccessToConfiguration(subject, filteredRepositories));
        }
        return permittedRepositories;
    }

    public void ensureUserHasAnyPermissionOrAdminAccess(Iterable<Permission> permissions, String action, Iterable<Repository> repositories) {
        Subject subject = this.securityHelper.subject();
        if (this.securityHelper.anyPermitted(subject, permissions)) {
            return;
        }
        Permission[] actionPermissions = (Permission[])StreamSupport.stream(repositories.spliterator(), false).map(r -> new RepositoryAdminPermission((Repository)r, action)).toArray(Permission[]::new);
        this.securityHelper.ensureAnyPermitted(subject, actionPermissions);
    }

    public List<Repository> userCanBrowseRepositories(Iterable<Repository> repositories) {
        return this.userCanBrowseRepositories((Repository[])Iterables.toArray(repositories, Repository.class));
    }

    public boolean userHasRepositoryAdminPermission(Repository repository, String ... actions) {
        return !this.userHasPermission(r -> new RepositoryAdminPermission((Repository)r, actions), repository).isEmpty();
    }

    public List<Repository> userHasRepositoryAdminPermission(Iterable<Repository> repositories, String ... actions) {
        Repository[] repos = (Repository[])Iterables.toArray(repositories, Repository.class);
        return this.userHasPermission(r -> new RepositoryAdminPermission((Repository)r, actions), repos);
    }

    public List<Configuration> userHasRepositoryAdminPermissionFor(Iterable<Configuration> configurations, String ... actions) {
        Configuration[] repos = (Configuration[])Iterables.toArray(configurations, Configuration.class);
        return this.userHasPermission(c -> new RepositoryAdminPermission(this.toFormat((Configuration)c), c.getRepositoryName(), actions), repos);
    }

    public void ensureUserCanAdmin(String action, Repository repository) {
        this.securityHelper.ensurePermitted(new Permission[]{new RepositoryAdminPermission(repository.getFormat().getValue(), repository.getName(), Collections.singletonList(action))});
    }

    public void ensureUserCanAdmin(String action, String format, String repositoryName) {
        this.securityHelper.ensurePermitted(new Permission[]{new RepositoryAdminPermission(format, repositoryName, Collections.singletonList(action))});
    }

    private <U> List<U> userHasPermission(Function<U, Permission> permissionSupplier, U ... repositories) {
        if (repositories.length == 0) {
            return Collections.emptyList();
        }
        Subject subject = this.securityHelper.subject();
        Permission[] permissions = (Permission[])Arrays.stream(repositories).map(permissionSupplier).toArray(Permission[]::new);
        boolean[] results = this.securityHelper.isPermitted(subject, permissions);
        ArrayList<U> permittedRepositories = new ArrayList<U>();
        int i = 0;
        while (i < results.length) {
            if (results[i]) {
                permittedRepositories.add(repositories[i]);
            }
            ++i;
        }
        return permittedRepositories;
    }

    private List<Repository> subjectHasAnyContentSelectorAccessTo(Subject subject, List<Repository> repositories) {
        List formats;
        List repositoryNames = repositories.stream().map(r -> r.getName()).collect(Collectors.toList());
        List selectors = this.selectorManager.browseActive(repositoryNames, formats = repositories.stream().map(r -> r.getFormat().getValue()).distinct().collect(Collectors.toList()));
        if (selectors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Repository> permittedRepositories = new ArrayList<Repository>();
        for (Repository repository : repositories) {
            Permission[] permissions = (Permission[])selectors.stream().map(s -> new RepositoryContentSelectorPermission((SelectorConfiguration)s, repository, Collections.singletonList("browse"))).toArray(Permission[]::new);
            if (!this.securityHelper.anyPermitted(subject, permissions)) continue;
            permittedRepositories.add(repository);
        }
        return permittedRepositories;
    }

    private List<Configuration> subjectHasAnyContentSelectorAccessToConfiguration(Subject subject, List<Configuration> configurations) {
        List formats;
        List repositoryNames = configurations.stream().map(Configuration::getRepositoryName).collect(Collectors.toList());
        List selectors = this.selectorManager.browseActive(repositoryNames, formats = configurations.stream().map(this::toFormat).distinct().collect(Collectors.toList()));
        if (selectors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Configuration> permittedRepositories = new ArrayList<Configuration>();
        for (Configuration configuration : configurations) {
            Permission[] permissions = (Permission[])selectors.stream().map(s -> new RepositoryContentSelectorPermission(s.getName(), this.toFormat(configuration), configuration.getRepositoryName(), Collections.singletonList("browse"))).toArray(Permission[]::new);
            if (!this.securityHelper.anyPermitted(subject, permissions)) continue;
            permittedRepositories.add(configuration);
        }
        return permittedRepositories;
    }

    private String toFormat(Configuration configuration) {
        return Optional.ofNullable(this.recipes.get(configuration.getRecipeName())).map(Recipe::getFormat).map(Format::getValue).orElseThrow(() -> new IllegalArgumentException("Unknown repository type: " + configuration.getRecipeName()));
    }

    private boolean userHasAnyContentSelectorAccessTo(Repository repository, String ... actions) {
        Subject subject = this.securityHelper.subject();
        return this.selectorManager.browse().stream().anyMatch(selector -> this.securityHelper.anyPermitted(subject, (Permission[])Arrays.stream(actions).map(action -> new RepositoryContentSelectorPermission((SelectorConfiguration)selector, repository, Collections.singletonList(action))).toArray(Permission[]::new)));
    }
}

