/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.RepositoryCombobox;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.security.RepositoryAdminPermission;
import org.sonatype.nexus.repository.security.RepositoryPrivilegeDescriptorSupport;
import org.sonatype.nexus.repository.security.rest.ApiPrivilegeRepositoryAdmin;
import org.sonatype.nexus.repository.security.rest.ApiPrivilegeRepositoryAdminRequest;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.CPrivilegeBuilder;
import org.sonatype.nexus.security.privilege.Privilege;

@Named(value="repository-admin")
@Singleton
public class RepositoryAdminPrivilegeDescriptor
extends RepositoryPrivilegeDescriptorSupport<ApiPrivilegeRepositoryAdmin, ApiPrivilegeRepositoryAdminRequest> {
    public static final String TYPE = "repository-admin";
    public static final String P_FORMAT = "format";
    public static final String P_REPOSITORY = "repository";
    public static final String P_ACTIONS = "actions";
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final List<FormField> formFields = ImmutableList.of((Object)new StringTextFormField("format", messages.format(), messages.formatHelp(), true), (Object)new RepositoryCombobox("repository", messages.repository(), messages.repositoryHelp(), true).includeAnEntryForAllRepositories(), (Object)new StringTextFormField("actions", messages.actions(), messages.actionsHelp(), true));

    @Inject
    public RepositoryAdminPrivilegeDescriptor(RepositoryManager repositoryManager, List<Format> formats) {
        super(TYPE, repositoryManager, formats);
    }

    public Permission createPermission(CPrivilege privilege) {
        Preconditions.checkNotNull((Object)privilege);
        String format = this.readProperty(privilege, P_FORMAT, "*");
        String name = this.readProperty(privilege, P_REPOSITORY, "*");
        List actions = this.readListProperty(privilege, P_ACTIONS, "*");
        return new RepositoryAdminPermission(format, name, actions);
    }

    public List<FormField> getFormFields() {
        return this.formFields;
    }

    public String getName() {
        return messages.name();
    }

    public static String id(String format, String name, String ... actions) {
        return String.format("nx-%s-%s-%s-%s", TYPE, format, name, Joiner.on((char)',').join((Object[])actions));
    }

    public static CPrivilege privilege(String format, String name, String ... actions) {
        Preconditions.checkArgument((actions.length > 0 ? 1 : 0) != 0);
        return new CPrivilegeBuilder().type(TYPE).id(RepositoryAdminPrivilegeDescriptor.id(format, name, actions)).description(String.format("%s for %s repository administration", RepositoryAdminPrivilegeDescriptor.humanizeActions((String[])actions), RepositoryAdminPrivilegeDescriptor.humanizeName((String)name, (String)format))).property(P_FORMAT, format).property(P_REPOSITORY, name).property(P_ACTIONS, actions).create();
    }

    public ApiPrivilegeRepositoryAdmin createApiPrivilegeImpl(Privilege privilege) {
        return new ApiPrivilegeRepositoryAdmin(privilege);
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Repository Admin")
        public String name();

        @MessageBundle.DefaultMessage(value="Format")
        public String format();

        @MessageBundle.DefaultMessage(value="The format(s) for the repository")
        public String formatHelp();

        @MessageBundle.DefaultMessage(value="Repository")
        public String repository();

        @MessageBundle.DefaultMessage(value="The repository name")
        public String repositoryHelp();

        @MessageBundle.DefaultMessage(value="Actions")
        public String actions();

        @MessageBundle.DefaultMessage(value="The comma-delimited list of actions")
        public String actionsHelp();
    }
}

