/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.table;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.search.SqlSearchQueryContribution;
import org.sonatype.nexus.repository.search.query.SearchFilter;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryBuilder;

@Named
@Singleton
public class TableSearchUtils
extends ComponentSupport {
    public static final String FORMAT = "format";
    private final Map<String, SqlSearchQueryContribution> searchContributions;
    private final SqlSearchQueryContribution defaultSqlSearchQueryContribution;

    @Inject
    public TableSearchUtils(Map<String, SqlSearchQueryContribution> searchContributions) {
        this.searchContributions = (Map)Preconditions.checkNotNull(searchContributions);
        this.defaultSqlSearchQueryContribution = (SqlSearchQueryContribution)Preconditions.checkNotNull((Object)searchContributions.get("datastore_search_defaultSqlSearchContribution"));
    }

    public SqlSearchQueryBuilder buildQuery(List<SearchFilter> searchFilters) {
        SqlSearchQueryBuilder queryBuilder = SqlSearchQueryBuilder.queryBuilder();
        searchFilters.stream().filter(searchFilter -> !Strings2.isBlank((String)searchFilter.getValue())).filter(filter -> !"repository_name".equalsIgnoreCase(filter.getProperty())).forEach(searchFilter -> {
            SqlSearchQueryContribution searchContribution = this.searchContributions.getOrDefault(this.getContributionKey((SearchFilter)searchFilter), this.defaultSqlSearchQueryContribution);
            searchContribution.contribute(queryBuilder, (SearchFilter)searchFilter);
        });
        this.log.debug("Query: {}", (Object)queryBuilder);
        return queryBuilder;
    }

    public Optional<SearchFilter> getRepositoryFilter(List<SearchFilter> filters) {
        return filters.stream().filter(searchFilter -> "repository_name".equals(searchFilter.getProperty())).findFirst();
    }

    private String getContributionKey(SearchFilter searchFilter) {
        return "datastore_search_" + searchFilter.getProperty();
    }
}

