/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.table;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.Permission;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.security.RepositoryViewPermission;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorManager;

@Named
@Singleton
public class TableSearchRepositoryPermissionUtil
extends ComponentSupport {
    private final RepositoryManager repositoryManager;
    private final SecurityHelper securityHelper;
    private final SelectorManager selectorManager;

    @Inject
    public TableSearchRepositoryPermissionUtil(RepositoryManager repositoryManager, SecurityHelper securityHelper, SelectorManager selectorManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.selectorManager = (SelectorManager)Preconditions.checkNotNull((Object)selectorManager);
    }

    public Set<String> browsableAndUnknownRepositories(Set<String> repositories) {
        this.log.debug("Checking {} for 'BROWSE' permissions and unknown repositories.", repositories);
        HashSet<String> browsableAndUnknownRepositories = new HashSet<String>();
        for (String repository : repositories) {
            if (this.repositoryManager.exists(repository) && !this.securityHelper.allPermitted(new Permission[]{new RepositoryViewPermission(repository, "browse", new String[0])})) continue;
            browsableAndUnknownRepositories.add(repository);
        }
        this.log.debug("Repositories with 'BROWSE' permissions and unknown repositories: {}", browsableAndUnknownRepositories);
        return browsableAndUnknownRepositories;
    }

    public List<SelectorConfiguration> selectorConfigurations(Set<String> repositories) {
        if (repositories.isEmpty()) {
            return Collections.emptyList();
        }
        this.log.debug("Fetching content selectors for {}", repositories);
        HashMap distinctConfigs = new HashMap();
        List<SelectorConfiguration> selectors = this.selectorManager.browseActive(repositories, Collections.emptyList()).stream().filter(selector -> this.distinctBySelectorExpression((SelectorConfiguration)selector, distinctConfigs)).collect(Collectors.toList());
        this.log.debug("Found {} distinct content selectors.", (Object)selectors.size());
        return selectors;
    }

    private boolean distinctBySelectorExpression(SelectorConfiguration selector, Map<String, SelectorConfiguration> selectorConfigs) {
        String expression = Optional.ofNullable(selector.getAttributes()).map(attr -> (String)attr.get("expression")).filter(StringUtils::isNotBlank).map(StringUtils::trim).orElse("");
        return selectorConfigs.putIfAbsent(expression, selector) == null;
    }
}

