/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.table;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.collections.CollectionUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.rest.SearchFieldSupport;
import org.sonatype.nexus.repository.rest.SearchMappings;
import org.sonatype.nexus.repository.search.SqlSearchRepositoryNameUtil;
import org.sonatype.nexus.repository.search.sql.SqlSearchContentSelectorFilter;
import org.sonatype.nexus.repository.search.sql.SqlSearchPermissionException;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryBuilder;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryCondition;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryConditionBuilder;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryContributionSupport;
import org.sonatype.nexus.repository.search.table.TableSearchContentSelectorSqlFilterGenerator;
import org.sonatype.nexus.repository.search.table.TableSearchRepositoryPermissionUtil;
import org.sonatype.nexus.selector.SelectorConfiguration;

@Named
public class TableSearchPermissionManager
extends ComponentSupport {
    private final SqlSearchQueryConditionBuilder conditionBuilder;
    private final SqlSearchRepositoryNameUtil repositoryNameUtil;
    private final TableSearchRepositoryPermissionUtil repositoryPermissionUtil;
    private final TableSearchContentSelectorSqlFilterGenerator contentSelectorFilterGenerator;
    private final Map<String, SearchFieldSupport> fieldMappings;
    private final RepositoryManager repositoryManager;

    @Inject
    public TableSearchPermissionManager(SqlSearchQueryConditionBuilder conditionBuilder, SqlSearchRepositoryNameUtil repositoryNameUtil, TableSearchRepositoryPermissionUtil repositoryPermissionUtil, Map<String, SearchMappings> searchMappings, TableSearchContentSelectorSqlFilterGenerator contentSelectorFilterGenerator, RepositoryManager repositoryManager) {
        this.conditionBuilder = (SqlSearchQueryConditionBuilder)((Object)Preconditions.checkNotNull((Object)((Object)conditionBuilder)));
        this.repositoryNameUtil = (SqlSearchRepositoryNameUtil)((Object)Preconditions.checkNotNull((Object)((Object)repositoryNameUtil)));
        this.repositoryPermissionUtil = (TableSearchRepositoryPermissionUtil)((Object)Preconditions.checkNotNull((Object)((Object)repositoryPermissionUtil)));
        this.fieldMappings = Collections.unmodifiableMap(SqlSearchQueryContributionSupport.fieldMappingsByAttribute((Map)Preconditions.checkNotNull(searchMappings)));
        this.contentSelectorFilterGenerator = (TableSearchContentSelectorSqlFilterGenerator)((Object)Preconditions.checkNotNull((Object)((Object)contentSelectorFilterGenerator)));
        this.repositoryManager = repositoryManager;
    }

    public void addPermissionFilters(SqlSearchQueryBuilder queryBuilder, @Nullable String searchFilter) {
        if (searchFilter != null) {
            this.addRepositoryPermissions(queryBuilder, searchFilter);
        } else {
            this.addRepositoryPermissions(queryBuilder);
        }
    }

    private void addRepositoryPermissions(SqlSearchQueryBuilder queryBuilder, String repositoryFilter) {
        Set<String> repositories = this.repositoryNameUtil.getRepositoryNames(repositoryFilter);
        if (!repositories.isEmpty()) {
            Set<String> browsableRepositories = this.getBrowsableRepositories(repositories);
            if (!repositories.equals(browsableRepositories)) {
                this.addBrowsableRepositoriesAndSelectorPermissions(queryBuilder, repositories, browsableRepositories);
            } else {
                this.createSqlCondition(browsableRepositories, Collections.emptySet(), Collections.emptyList()).ifPresent(queryBuilder::add);
            }
        }
    }

    private void addRepositoryPermissions(SqlSearchQueryBuilder queryBuilder) {
        Set<String> browsableRepositories;
        Set<String> repositories = StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).map(Repository::getName).collect(Collectors.toSet());
        if (!repositories.equals(browsableRepositories = this.getBrowsableRepositories(repositories))) {
            this.addBrowsableRepositoriesAndSelectorPermissions(queryBuilder, repositories, browsableRepositories);
        }
    }

    private Set<String> getBrowsableRepositories(Set<String> repositories) {
        return this.repositoryPermissionUtil.browsableAndUnknownRepositories(repositories);
    }

    private Set<String> getSelectorRepositories(Set<String> repositories, Set<String> browsableRepositories) {
        HashSet<String> selectorRepositories = new HashSet<String>(repositories);
        selectorRepositories.removeAll(browsableRepositories);
        return selectorRepositories;
    }

    private List<SelectorConfiguration> getSelectorConfigurations(Set<String> repositories) {
        return this.repositoryPermissionUtil.selectorConfigurations(repositories);
    }

    private void addBrowsableRepositoriesAndSelectorPermissions(SqlSearchQueryBuilder queryBuilder, Set<String> repositories, Set<String> browsableRepositories) {
        Set<String> selectorRepositories = this.getSelectorRepositories(repositories, browsableRepositories);
        List<SelectorConfiguration> selectors = this.getSelectorConfigurations(selectorRepositories);
        this.createSqlCondition(browsableRepositories, selectorRepositories, selectors).ifPresent(queryBuilder::add);
    }

    private Optional<SqlSearchQueryCondition> createSqlCondition(Set<String> browsableRepositories, Set<String> selectorRepositories, List<SelectorConfiguration> selectorConfigs) {
        if (browsableRepositories.isEmpty() && selectorConfigs.isEmpty()) {
            throw new SqlSearchPermissionException("User is not permitted.");
        }
        ArrayList conditions = new ArrayList();
        Optional.of(browsableRepositories).flatMap(this::createRepositoryCondition).ifPresent(conditions::add);
        Optional.of(selectorRepositories).flatMap(repos -> this.createContentSelectorCondition(selectorConfigs, (Set<String>)repos)).ifPresent(conditions::add);
        return Optional.of(conditions).filter(CollectionUtils::isNotEmpty).map(this.conditionBuilder::combine);
    }

    private Optional<SqlSearchQueryCondition> createRepositoryCondition(Set<String> repositories) {
        if (repositories.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.fieldMappings.get("repository_name")).map(SearchFieldSupport::getColumnName).map(field -> this.conditionBuilder.condition((String)field, repositories));
    }

    private Optional<SqlSearchQueryCondition> createContentSelectorCondition(List<SelectorConfiguration> selectors, Set<String> repositories) {
        if (selectors.isEmpty()) {
            return Optional.empty();
        }
        SqlSearchContentSelectorFilter contentAuthFilter = this.contentSelectorFilterGenerator.createFilter(selectors, repositories);
        if (contentAuthFilter.hasFilters()) {
            return Optional.of(new SqlSearchQueryCondition(contentAuthFilter.queryFormat(), contentAuthFilter.queryParameters()));
        }
        return Optional.empty();
    }
}

