/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.table;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.rest.SearchFieldSupport;
import org.sonatype.nexus.repository.rest.SearchMappings;
import org.sonatype.nexus.repository.search.sql.SqlSearchContentSelectorFilter;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryCondition;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryConditionBuilder;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryContributionSupport;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorEvaluationException;
import org.sonatype.nexus.selector.SelectorManager;
import org.sonatype.nexus.selector.SelectorSqlBuilder;

@Singleton
public class TableSearchContentSelectorSqlFilterGenerator
extends ComponentSupport {
    private static final String FILTER_PARAMS = "filterParams";
    private static final String PATH = "path";
    private static final String LEFT_PARENTHESIS = "(";
    private static final String RIGHT_PARENTHESIS = ")";
    private static final String OR = " OR ";
    private final SelectorManager selectorManager;
    private final SqlSearchQueryConditionBuilder conditionBuilder;
    protected final Map<String, SearchFieldSupport> fieldMappings;

    @Inject
    public TableSearchContentSelectorSqlFilterGenerator(SelectorManager selectorManager, SqlSearchQueryConditionBuilder conditionBuilder, Map<String, SearchMappings> searchMappings) {
        this.selectorManager = (SelectorManager)Preconditions.checkNotNull((Object)selectorManager);
        this.conditionBuilder = (SqlSearchQueryConditionBuilder)((Object)Preconditions.checkNotNull((Object)((Object)conditionBuilder)));
        this.fieldMappings = Collections.unmodifiableMap(SqlSearchQueryContributionSupport.fieldMappingsByAttribute((Map)Preconditions.checkNotNull(searchMappings)));
    }

    public SqlSearchContentSelectorFilter createFilter(List<SelectorConfiguration> selectors, Set<String> selectorRepositories) {
        SqlSearchContentSelectorFilter filters = new SqlSearchContentSelectorFilter();
        SelectorSqlBuilder selectorSqlBuilder = TableSearchContentSelectorSqlFilterGenerator.createSelectorSqlBuilder();
        int selectorCount = 0;
        while (selectorCount < selectors.size()) {
            block8: {
                SelectorConfiguration selector = selectors.get(selectorCount);
                if ("csel".equals(selector.getType())) {
                    if (selectorCount > 0) {
                        filters.appendQueryFormatPart(OR);
                    }
                    try {
                        try {
                            String namePrefix = "s" + selectorCount + "p";
                            this.transformSelectorToSql(selectorSqlBuilder, selector, namePrefix);
                            this.collectGeneratedSql(filters, selectorSqlBuilder, selectorRepositories, namePrefix);
                        }
                        catch (SelectorEvaluationException e) {
                            this.log.warn("Problem evaluating selector {} as SQL", (Object)selector.getName(), (Object)e);
                            selectorSqlBuilder.clearQueryString();
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        selectorSqlBuilder.clearQueryString();
                        throw throwable;
                    }
                    selectorSqlBuilder.clearQueryString();
                }
            }
            ++selectorCount;
        }
        TableSearchContentSelectorSqlFilterGenerator.maybeAddOuterParentheses(selectors.size(), filters);
        return filters;
    }

    private static SelectorSqlBuilder createSelectorSqlBuilder() {
        return new SelectorSqlBuilder().propertyAlias(PATH, PATH).parameterPrefix("#{filterParams.").parameterSuffix("}");
    }

    private static void maybeAddOuterParentheses(int numberOfSelectors, SqlSearchContentSelectorFilter filter) {
        if (numberOfSelectors > 1) {
            filter.insert(0, LEFT_PARENTHESIS);
            filter.appendQueryFormatPart(RIGHT_PARENTHESIS);
        }
    }

    private void transformSelectorToSql(SelectorSqlBuilder sqlBuilder, SelectorConfiguration selector, String namePrefix) throws SelectorEvaluationException {
        sqlBuilder.parameterNamePrefix(namePrefix);
        this.selectorManager.toSql(selector, sqlBuilder);
    }

    private void collectGeneratedSql(SqlSearchContentSelectorFilter filter, SelectorSqlBuilder sqlBuilder, Set<String> repositories, String namePrefix) {
        filter.putQueryParameters(sqlBuilder.getQueryParameters());
        filter.appendQueryFormatPart(LEFT_PARENTHESIS);
        filter.appendQueryFormatPart(sqlBuilder.getQueryString());
        if (!repositories.isEmpty()) {
            filter.appendQueryFormatPart(" AND ");
            SqlSearchQueryCondition condition = this.repositoryNameCondition(repositories, String.valueOf(namePrefix) + "_");
            filter.appendQueryFormatPart(condition.getSqlConditionFormat());
            filter.putQueryParameters(condition.getValues());
        }
        filter.appendQueryFormatPart(RIGHT_PARENTHESIS);
    }

    private SqlSearchQueryCondition repositoryNameCondition(Set<String> repositories, String namePrefix) {
        return this.conditionBuilder.condition(this.fieldMappings.get("repository_name").getColumnName(), repositories, namePrefix);
    }
}

