/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.sql;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.search.SqlSearchQueryContribution;
import org.sonatype.nexus.repository.search.query.SearchFilter;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryBuilder;

@Named
@Singleton
public class SqlSearchUtils
extends ComponentSupport {
    public static final String FORMAT = "format";
    private final Map<String, SqlSearchQueryContribution> searchContributions;
    private final SqlSearchQueryContribution defaultSqlSearchQueryContribution;

    @Inject
    public SqlSearchUtils(Map<String, SqlSearchQueryContribution> searchContributions) {
        this.searchContributions = (Map)Preconditions.checkNotNull(searchContributions);
        this.defaultSqlSearchQueryContribution = (SqlSearchQueryContribution)Preconditions.checkNotNull((Object)searchContributions.get("datastore_search_defaultSqlSearchContribution"));
    }

    public SqlSearchQueryBuilder buildQuery(List<SearchFilter> searchFilters) {
        SqlSearchQueryBuilder queryBuilder = SqlSearchQueryBuilder.queryBuilder();
        searchFilters.stream().filter(searchFilter -> !StringUtils.isBlank((CharSequence)searchFilter.getValue())).filter(filter -> !FORMAT.equalsIgnoreCase(filter.getProperty())).filter(filter -> !"repository_name".equalsIgnoreCase(filter.getProperty())).forEach(searchFilter -> {
            SqlSearchQueryContribution searchContribution = this.searchContributions.getOrDefault(this.getContributionKey((SearchFilter)searchFilter), this.defaultSqlSearchQueryContribution);
            searchContribution.contribute(queryBuilder, (SearchFilter)searchFilter);
        });
        this.log.debug("Query: {}", (Object)queryBuilder);
        return queryBuilder;
    }

    public Optional<String> getFormat(List<SearchFilter> searchFilters) {
        return searchFilters.stream().filter(searchFilter -> !StringUtils.isBlank((CharSequence)searchFilter.getValue())).filter(filter -> FORMAT.equalsIgnoreCase(filter.getProperty())).findFirst().map(SearchFilter::getValue);
    }

    public Optional<SearchFilter> getRepositoryFilter(List<SearchFilter> filters) {
        return filters.stream().filter(searchFilter -> "repository_name".equals(searchFilter.getProperty())).findFirst();
    }

    private String getContributionKey(SearchFilter searchFilter) {
        return "datastore_search_" + searchFilter.getProperty();
    }
}

