/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.sql;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.rest.SearchFieldSupport;
import org.sonatype.nexus.repository.rest.SearchMapping;
import org.sonatype.nexus.repository.rest.SearchMappings;
import org.sonatype.nexus.repository.search.SqlSearchQueryContribution;
import org.sonatype.nexus.repository.search.query.SearchFilter;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryBuilder;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryCondition;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryConditionBuilder;

public abstract class SqlSearchQueryContributionSupport
extends ComponentSupport
implements SqlSearchQueryContribution {
    private static final String QUOTE = "\"";
    private static final String DEFAULT_REGEX = "[^\\s\"]+|\"[^\"]+\"";
    private static final Pattern PATTERN = Pattern.compile("[^\\s\"]+|\"[^\"]+\"");
    public static final String NAME_PREFIX = "datastore_search_";
    protected final SqlSearchQueryConditionBuilder sqlSearchQueryConditionBuilder;
    protected final Map<String, SearchFieldSupport> fieldMappings;

    protected SqlSearchQueryContributionSupport(SqlSearchQueryConditionBuilder sqlSearchQueryConditionBuilder, Map<String, SearchMappings> searchMappings) {
        this.sqlSearchQueryConditionBuilder = (SqlSearchQueryConditionBuilder)((Object)Preconditions.checkNotNull((Object)((Object)sqlSearchQueryConditionBuilder)));
        this.fieldMappings = Collections.unmodifiableMap(SqlSearchQueryContributionSupport.fieldMappingsByAttribute((Map)Preconditions.checkNotNull(searchMappings)));
    }

    @Override
    public void contribute(SqlSearchQueryBuilder queryBuilder, SearchFilter searchFilter) {
        Optional.ofNullable(searchFilter).flatMap(this::buildQueryCondition).ifPresent(queryBuilder::add);
    }

    protected Optional<SqlSearchQueryCondition> buildQueryCondition(SearchFilter searchFilter) {
        SearchFilter mappedField = this.getFieldMapping(searchFilter);
        return Optional.ofNullable(mappedField).map(SearchFilter::getValue).map(this::split).filter(CollectionUtils::isNotEmpty).map(values -> this.sqlSearchQueryConditionBuilder.condition(mappedField.getProperty(), (Set<String>)values));
    }

    protected Set<String> split(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Collections.emptySet();
        }
        Matcher matcher = this.getMatcher(value);
        HashSet<String> matches = new HashSet<String>();
        while (matcher.find()) {
            matches.add(SqlSearchQueryContributionSupport.maybeTrimQuotes(matcher.group()));
        }
        return matches;
    }

    protected Matcher getMatcher(String value) {
        return PATTERN.matcher(value);
    }

    public static String maybeTrimQuotes(String value) {
        value = StringUtils.removeEnd((String)value, (String)QUOTE);
        value = StringUtils.removeStart((String)value, (String)QUOTE);
        return value;
    }

    public static Map<String, SearchFieldSupport> fieldMappingsByAttribute(Map<String, SearchMappings> searchMappings) {
        return searchMappings.entrySet().stream().flatMap(e -> StreamSupport.stream(((SearchMappings)e.getValue()).get().spliterator(), false)).collect(Collectors.toMap(SearchMapping::getAttribute, SearchMapping::getField));
    }

    @Nullable
    private SearchFilter getFieldMapping(SearchFilter searchFilter) {
        String property = searchFilter.getProperty();
        SearchFieldSupport searchFieldSupport = this.fieldMappings.get(property);
        if (searchFieldSupport != null) {
            String fieldMapping = searchFieldSupport.getColumnName();
            if (StringUtils.isNotBlank((CharSequence)fieldMapping)) {
                return new SearchFilter(fieldMapping, searchFilter.getValue());
            }
            this.log.debug("Ignoring unsupported search field {}", (Object)property);
        }
        return null;
    }
}

