/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.sql;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.search.sql.SqlSearchConditionType;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryCondition;

@Named
@Singleton
public class SqlSearchQueryConditionBuilder
extends ComponentSupport {
    public static final char ZERO_OR_MORE_CHARACTERS = '*';
    private static final char SQL_ANY_CHARACTER = '_';
    private static final char SQL_ZERO_OR_MORE_CHARACTERS = '%';
    private static final String LIKE = " LIKE ";
    private static final char ANY_CHARACTER = '?';
    private static final String VALUES_MUST_NOT_BE_EMPTY = "Values must not be empty.";
    private static final String FIELD_NAME_MUST_NOT_BE_EMPTY = "Field name must not be empty.";
    private static final String CONDITIONS_MUST_NOT_BE_EMPTY = "Conditions must not be empty.";
    private static final String FILTER_PARAMS = "filterParams";
    private static final String PLACEHOLDER_PARAMETER_PREFIX = "#{filterParams.";
    private static final String PLACEHOLDER_PARAMETER_SUFFIX = "}";
    private static final String COMMA = ",";
    private static final String LEFT_PARENTHESIS = "(";
    private static final String RIGHT_PARENTHESIS = ")";
    private static final String IN = " IN ";
    private static final String OR = " OR ";
    private static final char[] REGEX_IDENTIFIERS = new char[]{'*', '?'};

    public SqlSearchQueryCondition condition(String field, String value) {
        return this.createCondition(field, value, "");
    }

    public SqlSearchQueryCondition condition(String field, String value, String parameterPrefix) {
        return this.createCondition(field, value, parameterPrefix);
    }

    public SqlSearchQueryCondition condition(String fieldName, Set<String> values) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)fieldName), (Object)FIELD_NAME_MUST_NOT_BE_EMPTY);
        Preconditions.checkArgument((!values.isEmpty() ? 1 : 0) != 0, (Object)VALUES_MUST_NOT_BE_EMPTY);
        return this.createCondition(fieldName, values, "");
    }

    public SqlSearchQueryCondition condition(String fieldName, Set<String> values, String parameterPrefix) {
        return this.createCondition(fieldName, values, parameterPrefix);
    }

    private SqlSearchQueryCondition createCondition(String fieldName, Set<String> values, String parameterPrefix) {
        if (values.size() == 1) {
            return this.condition(fieldName, (String)Iterables.getOnlyElement(values), parameterPrefix);
        }
        Map<SqlSearchConditionType, Set<String>> valueGroups = SqlSearchQueryConditionBuilder.groupIntoExactOrWildcard(values);
        List<String> valueNames = SqlSearchQueryConditionBuilder.createValueNames(String.valueOf(parameterPrefix) + fieldName, values.size());
        List<String> placeholders = SqlSearchQueryConditionBuilder.createPlaceholders(valueNames);
        ArrayList<SqlSearchQueryCondition> conditions = new ArrayList<SqlSearchQueryCondition>();
        if (valueGroups.containsKey((Object)SqlSearchConditionType.EXACT)) {
            conditions.add(SqlSearchQueryConditionBuilder.createExactCondition(fieldName, valueGroups.get((Object)SqlSearchConditionType.EXACT), valueNames, placeholders));
        }
        if (valueGroups.containsKey((Object)SqlSearchConditionType.WILDCARD)) {
            conditions.add(SqlSearchQueryConditionBuilder.createWildcardCondition(fieldName, valueGroups, valueNames, placeholders));
        }
        return this.combine(conditions);
    }

    private SqlSearchQueryCondition createCondition(String field, String value, String parameterPrefix) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)field), (Object)FIELD_NAME_MUST_NOT_BE_EMPTY);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)value), (Object)"Value must not be empty.");
        if (SqlSearchQueryConditionBuilder.exactOrWildcard(value) == SqlSearchConditionType.EXACT) {
            return new SqlSearchQueryCondition(SqlSearchQueryConditionBuilder.equalTo(field, parameterPrefix), (Map<String, String>)ImmutableMap.of((Object)(String.valueOf(parameterPrefix) + field), (Object)value));
        }
        return new SqlSearchQueryCondition(SqlSearchQueryConditionBuilder.wildcard(field, SqlSearchQueryConditionBuilder.placeholder(String.valueOf(parameterPrefix) + field)), (Map<String, String>)ImmutableMap.of((Object)(String.valueOf(parameterPrefix) + field), (Object)SqlSearchQueryConditionBuilder.replaceWildcards(value)));
    }

    public SqlSearchQueryCondition combine(Collection<SqlSearchQueryCondition> conditions) {
        Preconditions.checkArgument((!conditions.isEmpty() ? 1 : 0) != 0, (Object)CONDITIONS_MUST_NOT_BE_EMPTY);
        if (conditions.size() == 1) {
            return (SqlSearchQueryCondition)Iterables.getOnlyElement(conditions);
        }
        return new SqlSearchQueryCondition(SqlSearchQueryConditionBuilder.join(conditions.stream().map(SqlSearchQueryCondition::getSqlConditionFormat), OR), SqlSearchQueryConditionBuilder.flattenValues(conditions.stream().map(SqlSearchQueryCondition::getValues)));
    }

    private static SqlSearchConditionType exactOrWildcard(String value) {
        if (SqlSearchQueryConditionBuilder.isWildcard(value)) {
            return SqlSearchConditionType.WILDCARD;
        }
        return SqlSearchConditionType.EXACT;
    }

    public static boolean isWildcard(String value) {
        return StringUtils.containsAny((CharSequence)value, (char[])REGEX_IDENTIFIERS);
    }

    private static String equalTo(String field, String parameterPrefix) {
        return String.format("%s = %s", field, SqlSearchQueryConditionBuilder.placeholder(String.valueOf(parameterPrefix) + field));
    }

    private static String wildcard(String fieldName, String placeholder) {
        return String.valueOf(fieldName) + LIKE + placeholder;
    }

    private static String placeholder(String field) {
        return PLACEHOLDER_PARAMETER_PREFIX + field + PLACEHOLDER_PARAMETER_SUFFIX;
    }

    private static String replaceWildcards(String value) {
        return value.replace('?', '_').replace('*', '%');
    }

    private static Map<SqlSearchConditionType, Set<String>> groupIntoExactOrWildcard(Set<String> values) {
        return values.stream().collect(Collectors.groupingBy(SqlSearchQueryConditionBuilder::exactOrWildcard, Collectors.toSet()));
    }

    private static List<String> createValueNames(String field, int size) {
        return IntStream.range(0, size).mapToObj(index -> String.valueOf(field) + index).collect(Collectors.toList());
    }

    private static List<String> createPlaceholders(List<String> values) {
        return values.stream().map(SqlSearchQueryConditionBuilder::placeholder).collect(Collectors.toList());
    }

    private static Map<String, String> nameValues(List<String> valueNames, Set<String> values) {
        ArrayList<String> theValues = new ArrayList<String>(values);
        return IntStream.range(0, Math.min(valueNames.size(), theValues.size())).mapToObj(index -> new AbstractMap.SimpleImmutableEntry<String, String>((String)valueNames.get(index), (String)theValues.get(index))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static SqlSearchQueryCondition createWildcardCondition(String fieldName, Map<SqlSearchConditionType, Set<String>> valueGroups, List<String> valueNames, List<String> placeholders) {
        Set<String> wildcardValues = valueGroups.get((Object)SqlSearchConditionType.WILDCARD);
        Set exactValues = valueGroups.getOrDefault((Object)SqlSearchConditionType.EXACT, Collections.emptySet());
        List<String> wildcardPlaceholders = placeholders.subList(exactValues.size(), placeholders.size());
        List<String> wildcardValueNames = valueNames.subList(exactValues.size(), placeholders.size());
        return new SqlSearchQueryCondition(SqlSearchQueryConditionBuilder.wildcards(fieldName, wildcardPlaceholders), SqlSearchQueryConditionBuilder.nameValues(wildcardValueNames, SqlSearchQueryConditionBuilder.replaceWildcards(wildcardValues)));
    }

    private static String wildcards(String fieldName, List<String> placeholders) {
        return placeholders.stream().map(value -> SqlSearchQueryConditionBuilder.wildcard(fieldName, value)).collect(Collectors.joining(OR, LEFT_PARENTHESIS, RIGHT_PARENTHESIS));
    }

    private static SqlSearchQueryCondition createExactCondition(String fieldName, Set<String> values, List<String> valueNames, List<String> placeholders) {
        List<String> exactPlaceholders = placeholders.subList(0, values.size());
        List<String> exactValueNames = valueNames.subList(0, values.size());
        return new SqlSearchQueryCondition(SqlSearchQueryConditionBuilder.in(fieldName, exactPlaceholders), SqlSearchQueryConditionBuilder.nameValues(exactValueNames, values));
    }

    private static Map<String, String> flattenValues(Stream<Map<String, String>> stream) {
        return stream.flatMap(value -> value.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static String join(Stream<String> stream, String delimiter) {
        return stream.collect(Collectors.joining(delimiter, LEFT_PARENTHESIS, RIGHT_PARENTHESIS));
    }

    private static String in(String field, List<String> placeholders) {
        return String.valueOf(field) + IN + SqlSearchQueryConditionBuilder.createInClausePlaceholders(placeholders);
    }

    private static String createInClausePlaceholders(List<String> values) {
        return SqlSearchQueryConditionBuilder.join(values.stream(), COMMA);
    }

    public static Set<String> replaceWildcards(Set<String> values) {
        return values.stream().map(SqlSearchQueryConditionBuilder::replaceWildcards).collect(Collectors.toSet());
    }
}

