/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.sql;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryCondition;

public class SqlSearchQueryBuilder {
    private static final String AND = " AND ";
    private final List<SqlSearchQueryCondition> conditions = new ArrayList<SqlSearchQueryCondition>();

    private SqlSearchQueryBuilder() {
    }

    public SqlSearchQueryBuilder add(SqlSearchQueryCondition condition) {
        Preconditions.checkArgument((boolean)Objects.nonNull(condition), (Object)"Condition must not be blank.");
        this.conditions.add(condition);
        return this;
    }

    public static SqlSearchQueryBuilder queryBuilder() {
        return new SqlSearchQueryBuilder();
    }

    public Optional<SqlSearchQueryCondition> buildQuery() {
        if (this.conditions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new SqlSearchQueryCondition(this.joinQueryFormats(), this.getValues()));
    }

    private String joinQueryFormats() {
        return this.conditions.stream().map(SqlSearchQueryCondition::getSqlConditionFormat).collect(Collectors.joining(AND));
    }

    private Map<String, String> getValues() {
        return this.conditions.stream().map(SqlSearchQueryCondition::getValues).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

