/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.sql;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.collections.CollectionUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.rest.SearchFieldSupport;
import org.sonatype.nexus.repository.rest.SearchMappings;
import org.sonatype.nexus.repository.search.SqlSearchRepositoryNameUtil;
import org.sonatype.nexus.repository.search.sql.SqlSearchContentSelectorFilter;
import org.sonatype.nexus.repository.search.sql.SqlSearchContentSelectorSqlFilterGenerator;
import org.sonatype.nexus.repository.search.sql.SqlSearchPermissionException;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryBuilder;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryCondition;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryConditionBuilder;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryContributionSupport;
import org.sonatype.nexus.repository.search.sql.SqlSearchRepositoryPermissionUtil;
import org.sonatype.nexus.selector.SelectorConfiguration;

@Named
public class SqlSearchPermissionManager
extends ComponentSupport {
    private final SqlSearchQueryConditionBuilder conditionBuilder;
    private final SqlSearchRepositoryNameUtil repositoryNameUtil;
    private final SqlSearchRepositoryPermissionUtil repositoryPermissionUtil;
    private final SqlSearchContentSelectorSqlFilterGenerator contentSelectorFilterGenerator;
    private final Map<String, SearchFieldSupport> fieldMappings;

    @Inject
    public SqlSearchPermissionManager(SqlSearchQueryConditionBuilder conditionBuilder, SqlSearchRepositoryNameUtil repositoryNameUtil, SqlSearchRepositoryPermissionUtil repositoryPermissionUtil, Map<String, SearchMappings> searchMappings, SqlSearchContentSelectorSqlFilterGenerator contentSelectorFilterGenerator) {
        this.conditionBuilder = (SqlSearchQueryConditionBuilder)((Object)Preconditions.checkNotNull((Object)((Object)conditionBuilder)));
        this.repositoryNameUtil = (SqlSearchRepositoryNameUtil)((Object)Preconditions.checkNotNull((Object)((Object)repositoryNameUtil)));
        this.repositoryPermissionUtil = (SqlSearchRepositoryPermissionUtil)((Object)Preconditions.checkNotNull((Object)((Object)repositoryPermissionUtil)));
        this.fieldMappings = Collections.unmodifiableMap(SqlSearchQueryContributionSupport.fieldMappingsByAttribute((Map)Preconditions.checkNotNull(searchMappings)));
        this.contentSelectorFilterGenerator = (SqlSearchContentSelectorSqlFilterGenerator)((Object)Preconditions.checkNotNull((Object)((Object)contentSelectorFilterGenerator)));
    }

    public void addPermissionFilters(SqlSearchQueryBuilder queryBuilder, String format, @Nullable String searchFilter) {
        if (searchFilter != null) {
            this.addRepositoryPermissions(queryBuilder, searchFilter, format);
        } else {
            this.addRepositoryPermissions(queryBuilder, format);
        }
    }

    private void addRepositoryPermissions(SqlSearchQueryBuilder queryBuilder, String repositoryFilter, String format) {
        Set<String> repositories = this.repositoryNameUtil.getRepositoryNames(repositoryFilter);
        if (!repositories.isEmpty()) {
            Set<String> browsableRepositories = this.getBrowsableRepositories(format, repositories);
            if (!repositories.equals(browsableRepositories)) {
                this.addBrowsableRepositoriesAndSelectorPermissions(queryBuilder, format, repositories, browsableRepositories);
            } else {
                this.createSqlCondition(browsableRepositories, Collections.emptySet(), Collections.emptyList(), format).ifPresent(queryBuilder::add);
            }
        }
    }

    private void addRepositoryPermissions(SqlSearchQueryBuilder queryBuilder, String format) {
        Set<String> browsableRepositories;
        Set<String> repositories = this.repositoryNameUtil.getFormatRepositoryNames(format);
        if (!repositories.equals(browsableRepositories = this.getBrowsableRepositories(format, repositories))) {
            this.addBrowsableRepositoriesAndSelectorPermissions(queryBuilder, format, repositories, browsableRepositories);
        }
    }

    private Set<String> getBrowsableRepositories(String format, Set<String> repositories) {
        return this.repositoryPermissionUtil.browsableAndUnknownRepositories(format, repositories);
    }

    private Set<String> getSelectorRepositories(Set<String> repositories, Set<String> browsableRepositories) {
        HashSet<String> selectorRepositories = new HashSet<String>(repositories);
        selectorRepositories.removeAll(browsableRepositories);
        return selectorRepositories;
    }

    private List<SelectorConfiguration> getSelectorConfigurations(String format, Set<String> repositories) {
        return this.repositoryPermissionUtil.selectorConfigurations(repositories, Collections.singletonList(format));
    }

    private void addBrowsableRepositoriesAndSelectorPermissions(SqlSearchQueryBuilder queryBuilder, String format, Set<String> repositories, Set<String> browsableRepositories) {
        Set<String> selectorRepositories = this.getSelectorRepositories(repositories, browsableRepositories);
        List<SelectorConfiguration> selectors = this.getSelectorConfigurations(format, selectorRepositories);
        this.createSqlCondition(browsableRepositories, selectorRepositories, selectors, format).ifPresent(queryBuilder::add);
    }

    private Optional<SqlSearchQueryCondition> createSqlCondition(Set<String> browsableRepositories, Set<String> selectorRepositories, List<SelectorConfiguration> selectorConfigs, String format) {
        if (browsableRepositories.isEmpty() && selectorConfigs.isEmpty()) {
            throw new SqlSearchPermissionException("User is not permitted.");
        }
        ArrayList conditions = new ArrayList();
        Optional.of(browsableRepositories).flatMap(this::createRepositoryCondition).ifPresent(conditions::add);
        Optional.of(selectorRepositories).flatMap(repos -> this.createContentSelectorCondition(selectorConfigs, (Set<String>)repos, format)).ifPresent(conditions::add);
        return Optional.of(conditions).filter(CollectionUtils::isNotEmpty).map(this.conditionBuilder::combine);
    }

    private Optional<SqlSearchQueryCondition> createRepositoryCondition(Set<String> repositories) {
        if (repositories.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.fieldMappings.get("repository_name")).map(SearchFieldSupport::getColumnName).map(field -> this.conditionBuilder.condition((String)field, repositories));
    }

    private Optional<SqlSearchQueryCondition> createContentSelectorCondition(List<SelectorConfiguration> selectors, Set<String> repositories, String format) {
        if (selectors.isEmpty()) {
            return Optional.empty();
        }
        SqlSearchContentSelectorFilter contentAuthFilter = this.contentSelectorFilterGenerator.createFilter(selectors, repositories, format);
        if (contentAuthFilter.hasFilters()) {
            return Optional.of(new SqlSearchQueryCondition(contentAuthFilter.queryFormat(), contentAuthFilter.queryParameters()));
        }
        return Optional.empty();
    }
}

