/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.sql;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SqlSearchContentSelectorFilter {
    private final StringBuilder queryFormat = new StringBuilder();
    private final Map<String, String> queryParameters = new HashMap<String, String>();

    public void appendQueryFormatPart(String value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)value), (Object)"Value cannot be blank.");
        this.queryFormat.append(value);
    }

    public void putQueryParameters(Map<String, String> queryParameters) {
        Preconditions.checkArgument((!queryParameters.isEmpty() ? 1 : 0) != 0, (Object)"Parameters cannot be empty.");
        this.queryParameters.putAll(queryParameters);
    }

    public void insert(int position, String value) {
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"Position cannot be negative.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)value), (Object)"Value cannot be blank.");
        this.queryFormat.insert(position, value);
    }

    public boolean hasFilters() {
        return !this.queryFormat.toString().isEmpty() && !this.queryParameters.isEmpty();
    }

    public String queryFormat() {
        return this.queryFormat.toString();
    }

    public Map<String, String> queryParameters() {
        return Collections.unmodifiableMap(this.queryParameters);
    }
}

