/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.selector;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import org.apache.shiro.subject.Subject;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.NativeScriptFactory;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.sonatype.nexus.repository.search.selector.ContentAuthPlugin;
import org.sonatype.nexus.repository.search.selector.ContentAuthPluginScript;

public class ContentAuthPluginScriptFactory
implements NativeScriptFactory {
    private static final String SUBJECT_PARAM = "subject";

    public ExecutableScript newScript(Map<String, Object> params) {
        Preconditions.checkNotNull(params);
        String subjectId = (String)Preconditions.checkNotNull((Object)params.get(SUBJECT_PARAM));
        Subject subject = ContentAuthPlugin.getSearchSubjectHelper().getSubject(subjectId);
        return new ContentAuthPluginScript(subject, ContentAuthPlugin.getContentPermissionChecker(), ContentAuthPlugin.getVariableResolverAdapterManager(), ContentAuthPlugin.getRepositoryManager(), ContentAuthPlugin.getContentAuthSleep());
    }

    public boolean needsScores() {
        return false;
    }

    public static Script newScript(String subjectId) {
        Preconditions.checkNotNull((Object)subjectId);
        return new Script("content_auth", ScriptService.ScriptType.INLINE, "native", Collections.singletonMap(SUBJECT_PARAM, subjectId));
    }
}

