/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.query;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.subject.Subject;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Singleton
public class SearchSubjectHelper
extends ComponentSupport {
    @VisibleForTesting
    final Map<String, Subject> subjects = new ConcurrentHashMap<String, Subject>();

    public SubjectRegistration register(Subject subject) {
        Preconditions.checkNotNull((Object)subject);
        String uuid = UUID.randomUUID().toString();
        if (this.subjects.putIfAbsent(uuid, subject) != null) {
            throw new IllegalStateException("Duplicate UUID: " + uuid);
        }
        return new SubjectRegistration(uuid);
    }

    public Subject getSubject(String subjectId) {
        Preconditions.checkNotNull((Object)subjectId);
        return (Subject)Preconditions.checkNotNull((Object)this.subjects.get(subjectId), (String)"No subject for ID %s", (Object)subjectId);
    }

    private void unregister(String subjectId) {
        Preconditions.checkNotNull((Object)subjectId);
        this.subjects.remove(subjectId);
    }

    public class SubjectRegistration
    implements AutoCloseable {
        private final String id;

        public SubjectRegistration(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public void close() {
            SearchSubjectHelper.this.unregister(this.id);
        }
    }
}

