/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.query;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.search.SearchResponse;
import org.sonatype.nexus.repository.search.query.SearchResultComponentGenerator;
import org.sonatype.nexus.repository.search.query.SearchResultsGenerator;

@Named
@Singleton
public class SearchResultsGeneratorImpl
implements SearchResultsGenerator {
    private final Map<String, SearchResultComponentGenerator> searchResultComponentGeneratorMap;
    private final SearchResultComponentGenerator defaultSearchResultComponentGenerator;

    @Inject
    SearchResultsGeneratorImpl(Map<String, SearchResultComponentGenerator> searchResultComponentGeneratorMap) {
        this.searchResultComponentGeneratorMap = searchResultComponentGeneratorMap;
        this.defaultSearchResultComponentGenerator = searchResultComponentGeneratorMap.get("default");
    }

    @Override
    public List<ComponentSearchResult> getSearchResultList(SearchResponse response) {
        HashSet componentIdSet = new HashSet();
        return response.getSearchResults().stream().map(component -> {
            String format = component.getFormat();
            SearchResultComponentGenerator generator = this.searchResultComponentGeneratorMap.getOrDefault(format, this.defaultSearchResultComponentGenerator);
            ComponentSearchResult hit = generator.from((ComponentSearchResult)component, componentIdSet);
            if (hit != null) {
                componentIdSet.add(hit.getId());
            }
            return hit;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

