/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.query;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.sonatype.nexus.repository.Repository;

public class RepositoryQueryBuilder
extends QueryBuilder {
    private final QueryBuilder query;
    List<SortBuilder> sort;
    Collection<String> repositoryNames;
    Duration timeout;
    boolean skipContentSelectors;

    private RepositoryQueryBuilder(QueryBuilder query) {
        this.query = (QueryBuilder)Preconditions.checkNotNull((Object)query);
    }

    public static RepositoryQueryBuilder repositoryQuery(QueryBuilder query) {
        return query instanceof RepositoryQueryBuilder ? (RepositoryQueryBuilder)query : new RepositoryQueryBuilder(query);
    }

    public RepositoryQueryBuilder sortBy(List<SortBuilder> sort) {
        this.sort = (List)Preconditions.checkNotNull(sort);
        return this;
    }

    public RepositoryQueryBuilder sortBy(SortBuilder ... sort) {
        this.sort = ImmutableList.copyOf((Object[])sort);
        return this;
    }

    public RepositoryQueryBuilder inRepositories(Collection<String> repositoryNames) {
        this.repositoryNames = (Collection)Preconditions.checkNotNull(repositoryNames);
        return this;
    }

    public RepositoryQueryBuilder inRepositories(String ... repositoryNames) {
        this.repositoryNames = ImmutableList.copyOf((Object[])repositoryNames);
        return this;
    }

    public RepositoryQueryBuilder inRepositories(Repository ... repositories) {
        this.repositoryNames = (Collection)Arrays.stream(repositories).map(Repository::getName).collect(ImmutableList.toImmutableList());
        return this;
    }

    public RepositoryQueryBuilder timeout(Duration timeout) {
        this.timeout = (Duration)Preconditions.checkNotNull((Object)timeout);
        return this;
    }

    public RepositoryQueryBuilder unrestricted() {
        this.skipContentSelectors = true;
        return this;
    }

    public static RepositoryQueryBuilder unrestricted(QueryBuilder query) {
        return RepositoryQueryBuilder.repositoryQuery(query).unrestricted();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.query.toXContent(builder, params);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    @VisibleForTesting
    public Collection<String> getRepositoryNames() {
        return ImmutableList.copyOf(this.repositoryNames);
    }
}

