/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.query;

import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.sonatype.nexus.repository.search.query.ElasticSearchContributionSupport;

@Named(value="keyword")
@Singleton
public class KeywordElasticSearchContribution
extends ElasticSearchContributionSupport {
    public static final String NAME = "keyword";
    private Pattern dependencyPattern = Pattern.compile("^(?<group>[^\\s:]+):(?<name>[^\\s:]+)(:(?<version>[^\\s:]+))?(:(?<extension>[^\\s:]+))?(:(?<classifier>[^\\s:]+))?$");

    @Override
    public void contribute(Consumer<QueryBuilder> query, String type, String value) {
        if (value == null) {
            return;
        }
        Matcher gavSearchMatcher = this.dependencyPattern.matcher(value.trim());
        if (gavSearchMatcher.matches()) {
            String group = gavSearchMatcher.group("group");
            String name = gavSearchMatcher.group("name");
            String version = gavSearchMatcher.group("version");
            String extension = gavSearchMatcher.group("extension");
            String classifier = gavSearchMatcher.group("classifier");
            BoolQueryBuilder gavQuery = QueryBuilders.boolQuery();
            this.buildGavQuery(gavQuery, group, name, version, extension, classifier);
            query.accept((QueryBuilder)gavQuery);
        } else {
            String escaped = this.escape(value);
            QueryStringQueryBuilder keywordQuery = QueryBuilders.queryStringQuery((String)escaped).field("name.case_insensitive").field("group.case_insensitive").field("_all");
            query.accept((QueryBuilder)keywordQuery);
        }
    }

    private void buildGavQuery(BoolQueryBuilder gavQuery, String group, String name, String version, String extension, String classifier) {
        if (group != null) {
            gavQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"group.raw", (String)group));
        }
        if (name != null) {
            gavQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"name.raw", (String)name));
        }
        if (version != null) {
            gavQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"version", (String)version));
        }
        if (extension != null) {
            gavQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"assets.attributes.maven2.extension", (String)extension));
        }
        if (classifier != null) {
            gavQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"assets.attributes.maven2.classifier", (String)classifier));
        }
    }
}

