/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.query;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequestBuilder;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequestBuilder;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.ScriptQueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.profile.ProfileShardResult;
import org.elasticsearch.search.sort.SortBuilder;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.index.IndexNamingPolicy;
import org.sonatype.nexus.repository.search.index.SearchIndexFacet;
import org.sonatype.nexus.repository.search.query.ElasticSearchQueryService;
import org.sonatype.nexus.repository.search.query.RepositoryQueryBuilder;
import org.sonatype.nexus.repository.search.query.SearchSubjectHelper;
import org.sonatype.nexus.repository.search.selector.ContentAuthPluginScriptFactory;
import org.sonatype.nexus.repository.security.RepositoryViewPermission;
import org.sonatype.nexus.security.SecurityHelper;

@Named(value="default")
@Singleton
public class ElasticSearchQueryServiceImpl
extends ComponentSupport
implements ElasticSearchQueryService {
    private static final SearchResponse EMPTY_SEARCH_RESPONSE = new SearchResponse(InternalSearchResponse.empty(), null, 0, 0, 0L, new ShardSearchFailure[0]);
    private final Provider<Client> client;
    private final RepositoryManager repositoryManager;
    private final SecurityHelper securityHelper;
    private final SearchSubjectHelper searchSubjectHelper;
    private final IndexNamingPolicy indexNamingPolicy;
    private final boolean profile;

    @Inject
    public ElasticSearchQueryServiceImpl(Provider<Client> client, RepositoryManager repositoryManager, SecurityHelper securityHelper, SearchSubjectHelper searchSubjectHelper, IndexNamingPolicy indexNamingPolicy, @Named(value="${nexus.elasticsearch.profile:-false}") boolean profile) {
        this.client = (Provider)Preconditions.checkNotNull(client);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.searchSubjectHelper = (SearchSubjectHelper)((Object)Preconditions.checkNotNull((Object)((Object)searchSubjectHelper)));
        this.indexNamingPolicy = (IndexNamingPolicy)Preconditions.checkNotNull((Object)indexNamingPolicy);
        this.profile = profile;
    }

    @Override
    public Iterable<SearchHit> browse(QueryBuilder query) {
        if (!this.validateQuery(query)) {
            return Collections.emptyList();
        }
        RepositoryQueryBuilder repoQuery = RepositoryQueryBuilder.repositoryQuery(query);
        String[] searchableIndexes = this.getSearchableIndexes(repoQuery);
        if (searchableIndexes.length == 0) {
            return Collections.emptyList();
        }
        return () -> new SearchHitIterator(query, searchableIndexes, repositoryQueryBuilder.skipContentSelectors);
    }

    @Override
    public SearchResponse search(QueryBuilder query, int from, int size) {
        if (!this.validateQuery(query)) {
            return EMPTY_SEARCH_RESPONSE;
        }
        RepositoryQueryBuilder repoQuery = RepositoryQueryBuilder.repositoryQuery(query);
        String[] searchableIndexes = this.getSearchableIndexes(repoQuery);
        if (searchableIndexes.length == 0) {
            return EMPTY_SEARCH_RESPONSE;
        }
        if (repoQuery.skipContentSelectors) {
            return this.executeSearch(repoQuery, searchableIndexes, from, size, null);
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (SearchSubjectHelper.SubjectRegistration registration = this.searchSubjectHelper.register(this.securityHelper.subject());){
            ScriptQueryBuilder selectorFilter = QueryBuilders.scriptQuery((Script)ContentAuthPluginScriptFactory.newScript(registration.getId()));
            return this.executeSearch(repoQuery, searchableIndexes, from, size, (QueryBuilder)selectorFilter);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public SearchResponse search(QueryBuilder query, List<AggregationBuilder> aggregations) {
        if (!this.validateQuery(query)) {
            return EMPTY_SEARCH_RESPONSE;
        }
        Preconditions.checkNotNull(aggregations);
        RepositoryQueryBuilder repoQuery = RepositoryQueryBuilder.repositoryQuery(query);
        String[] searchableIndexes = this.getSearchableIndexes(repoQuery);
        if (searchableIndexes.length == 0) {
            return EMPTY_SEARCH_RESPONSE;
        }
        if (repoQuery.skipContentSelectors) {
            return this.executeSearch(repoQuery, searchableIndexes, aggregations, null);
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (SearchSubjectHelper.SubjectRegistration registration = this.searchSubjectHelper.register(this.securityHelper.subject());){
            ScriptQueryBuilder selectorFilter = QueryBuilders.scriptQuery((Script)ContentAuthPluginScriptFactory.newScript(registration.getId()));
            return this.executeSearch(repoQuery, searchableIndexes, aggregations, (QueryBuilder)selectorFilter);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private SearchResponse executeSearch(RepositoryQueryBuilder repoQuery, String[] searchableIndexes, int from, int size, @Nullable QueryBuilder postFilter) {
        SearchRequestBuilder searchRequestBuilder = ((Client)this.client.get()).prepareSearch(searchableIndexes).setTypes(new String[]{"component"}).setQuery((QueryBuilder)repoQuery).setFrom(from).setSize(size).setProfile(this.profile);
        if (repoQuery.sort != null) {
            for (SortBuilder entry : repoQuery.sort) {
                searchRequestBuilder.addSort(entry);
            }
        }
        if (postFilter != null) {
            searchRequestBuilder.setPostFilter(postFilter);
        }
        if (repoQuery.timeout != null) {
            searchRequestBuilder.setTimeout(String.valueOf(repoQuery.timeout.getSeconds()) + "s");
        }
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet();
        if (this.profile) {
            this.logProfileResults(searchResponse);
        }
        return searchResponse;
    }

    private SearchResponse executeSearch(RepositoryQueryBuilder repoQuery, String[] searchableIndexes, List<AggregationBuilder> aggregations, @Nullable QueryBuilder postFilter) {
        SearchRequestBuilder searchRequestBuilder = ((Client)this.client.get()).prepareSearch(searchableIndexes).setTypes(new String[]{"component"}).setQuery((QueryBuilder)repoQuery).setFrom(0).setSize(0).setProfile(this.profile).setTrackScores(true);
        for (AggregationBuilder aggregation : aggregations) {
            searchRequestBuilder.addAggregation((AbstractAggregationBuilder)aggregation);
        }
        if (repoQuery.sort != null) {
            for (SortBuilder entry : repoQuery.sort) {
                searchRequestBuilder.addSort(entry);
            }
        }
        if (postFilter != null) {
            searchRequestBuilder.setPostFilter(postFilter);
        }
        if (repoQuery.timeout != null) {
            searchRequestBuilder.setTimeout(String.valueOf(repoQuery.timeout.getSeconds()) + "s");
        }
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet();
        if (this.profile) {
            this.logProfileResults(searchResponse);
        }
        return searchResponse;
    }

    @Override
    public long count(QueryBuilder query) {
        if (!this.validateQuery(query)) {
            return 0L;
        }
        RepositoryQueryBuilder repoQuery = RepositoryQueryBuilder.repositoryQuery(query);
        String[] searchableIndexes = this.getSearchableIndexes(repoQuery);
        if (searchableIndexes.length == 0) {
            return 0L;
        }
        SearchRequestBuilder searchRequestBuilder = ((Client)this.client.get()).prepareSearch(searchableIndexes).setTypes(new String[]{"component"}).setQuery((QueryBuilder)repoQuery).setFrom(0).setSize(0);
        if (repoQuery.skipContentSelectors) {
            return ((SearchResponse)searchRequestBuilder.execute().actionGet()).getHits().totalHits();
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (SearchSubjectHelper.SubjectRegistration registration = this.searchSubjectHelper.register(this.securityHelper.subject());){
            ScriptQueryBuilder selectorFilter = QueryBuilders.scriptQuery((Script)ContentAuthPluginScriptFactory.newScript(registration.getId()));
            searchRequestBuilder.setPostFilter((QueryBuilder)selectorFilter);
            return ((SearchResponse)searchRequestBuilder.execute().actionGet()).getHits().totalHits();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean validateQuery(QueryBuilder query) {
        Preconditions.checkNotNull((Object)query);
        try {
            ValidateQueryResponse validateQueryResponse;
            ValidateQueryRequestBuilder validateRequest = this.indicesAdminClient().prepareValidateQuery(new String[0]).setQuery(query);
            if (this.log.isDebugEnabled()) {
                validateRequest.setExplain(true);
            }
            if (!(validateQueryResponse = (ValidateQueryResponse)validateRequest.execute().actionGet()).isValid()) {
                if (this.log.isDebugEnabled()) {
                    String explanations = validateQueryResponse.getQueryExplanation().stream().map(input -> input.getExplanation() != null ? input.getExplanation() : input.getError()).collect(Collectors.joining());
                    this.log.debug("Invalid query explanation: {}", (Object)explanations);
                }
                throw new IllegalArgumentException("Invalid query");
            }
            return true;
        }
        catch (IndexNotFoundException indexNotFoundException) {
            return false;
        }
    }

    @VisibleForTesting
    String[] getSearchableIndexes(RepositoryQueryBuilder repoQuery) {
        Stream<Repository> repositories = StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).filter(ElasticSearchQueryServiceImpl::repoOnlineAndHasSearchIndexFacet);
        if (repoQuery.repositoryNames != null) {
            repositories = repositories.filter(r -> repositoryQueryBuilder.repositoryNames.contains(r.getName()));
        }
        if (repoQuery.skipContentSelectors) {
            repositories = repositories.filter(r -> this.securityHelper.allPermitted(new Permission[]{new RepositoryViewPermission((Repository)r, "browse")}));
        }
        return (String[])repositories.map(this.indexNamingPolicy::indexName).toArray(String[]::new);
    }

    private static boolean repoOnlineAndHasSearchIndexFacet(Repository repo) {
        return repo.optionalFacet(SearchIndexFacet.class).isPresent() && repo.getConfiguration().isOnline();
    }

    private IndicesAdminClient indicesAdminClient() {
        return ((Client)this.client.get()).admin().indices();
    }

    private void logProfileResults(SearchResponse searchResponse) {
        for (Map.Entry entry : searchResponse.getProfileResults().entrySet()) {
            for (ProfileShardResult profileShardResult : (List)entry.getValue()) {
                try {
                    XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
                    builder.startObject();
                    profileShardResult.toXContent(builder, ToXContent.EMPTY_PARAMS);
                    builder.endObject();
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info("Elasticsearch profile for {} is: {}", entry.getKey(), (Object)builder.string());
                }
                catch (IOException e) {
                    this.log.error("Error writing elasticsearch profile result", (Throwable)e);
                }
            }
        }
    }

    private class SearchHitIterator
    implements Iterator<SearchHit> {
        private final QueryBuilder query;
        private final String[] searchableIndexes;
        private final boolean skipPermissionCheck;
        private SearchResponse response;
        private Iterator<SearchHit> iterator;
        private boolean noMoreHits = false;

        SearchHitIterator(QueryBuilder query, String[] searchableIndexes, boolean skipPermissionCheck) {
            this.query = query;
            this.searchableIndexes = searchableIndexes;
            this.skipPermissionCheck = skipPermissionCheck;
        }

        @Override
        public boolean hasNext() {
            if (this.noMoreHits) {
                return false;
            }
            if (this.response == null) {
                block14: {
                    SearchRequestBuilder builder = ((Client)ElasticSearchQueryServiceImpl.this.client.get()).prepareSearch(this.searchableIndexes).setTypes(new String[]{"component"}).setQuery(this.query).setScroll(new TimeValue(1L, TimeUnit.MINUTES)).setSize(100).setProfile(ElasticSearchQueryServiceImpl.this.profile);
                    if (!this.skipPermissionCheck) {
                        Throwable throwable = null;
                        Object var3_5 = null;
                        try (SearchSubjectHelper.SubjectRegistration registration = ElasticSearchQueryServiceImpl.this.searchSubjectHelper.register(ElasticSearchQueryServiceImpl.this.securityHelper.subject());){
                            ScriptQueryBuilder selectorFilter = QueryBuilders.scriptQuery((Script)ContentAuthPluginScriptFactory.newScript(registration.getId()));
                            builder.setPostFilter((QueryBuilder)selectorFilter);
                            this.response = (SearchResponse)builder.execute().actionGet();
                            break block14;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    this.response = (SearchResponse)builder.execute().actionGet();
                }
                this.iterator = Arrays.asList(this.response.getHits().getHits()).iterator();
                this.noMoreHits = !this.iterator.hasNext();
            } else if (!this.iterator.hasNext()) {
                SearchScrollRequestBuilder builder = ((Client)ElasticSearchQueryServiceImpl.this.client.get()).prepareSearchScroll(this.response.getScrollId()).setScroll(new TimeValue(1L, TimeUnit.MINUTES));
                this.response = (SearchResponse)builder.execute().actionGet();
                this.iterator = Arrays.asList(this.response.getHits().getHits()).iterator();
                this.noMoreHits = !this.iterator.hasNext();
            }
            return this.iterator.hasNext();
        }

        @Override
        public SearchHit next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEachRemaining(Consumer<? super SearchHit> action) {
            Iterator.super.forEachRemaining(action);
            this.closeScrollId();
        }

        private void closeScrollId() {
            ElasticSearchQueryServiceImpl.this.log.debug("Clearing scroll id {}", (Object)this.response.getScrollId());
            ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
            clearScrollRequest.addScrollId(this.response.getScrollId());
            ClearScrollResponse clearScrollResponse = (ClearScrollResponse)((Client)ElasticSearchQueryServiceImpl.this.client.get()).clearScroll(clearScrollRequest).actionGet();
            if (!clearScrollResponse.isSucceeded()) {
                ElasticSearchQueryServiceImpl.this.log.info("Unable to close scroll id {}", (Object)this.response.getScrollId());
            }
        }
    }
}

