/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.index;

import com.google.common.base.Preconditions;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.index.ElasticSearchIndexService;
import org.sonatype.nexus.repository.search.index.SearchIndexFacet;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class IndexStartupRebuildManager
extends LifecycleSupport {
    public static final String REBUILD_ON_STARTUP_VARIABLE_NAME = "NEXUS_SEARCH_INDEX_REBUILD_ON_STARTUP";
    private final TaskScheduler taskScheduler;
    private final RepositoryManager repositoryManager;
    private final ElasticSearchIndexService elasticSearchIndexService;
    private final boolean rebuildOnStart;

    @Inject
    public IndexStartupRebuildManager(TaskScheduler taskScheduler, RepositoryManager repositoryManager, ElasticSearchIndexService elasticSearchIndexService) {
        this(taskScheduler, repositoryManager, elasticSearchIndexService, System.getenv(REBUILD_ON_STARTUP_VARIABLE_NAME));
    }

    public IndexStartupRebuildManager(TaskScheduler taskScheduler, RepositoryManager repositoryManager, ElasticSearchIndexService elasticSearchIndexService, @Nullable String rebuildOnStartEnvVar) {
        this.taskScheduler = taskScheduler;
        this.rebuildOnStart = Boolean.parseBoolean(rebuildOnStartEnvVar);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.elasticSearchIndexService = (ElasticSearchIndexService)Preconditions.checkNotNull((Object)elasticSearchIndexService);
    }

    protected void doStart() throws Exception {
        if (this.rebuildOnStart && this.allIndicesEmpty()) {
            this.log.info("Scheduling rebuild of repository indexes");
            this.doRebuildAllIndexes();
        } else {
            this.log.info("Skipping rebuild of repository indexes");
        }
    }

    private void doRebuildAllIndexes() {
        try {
            TaskConfiguration taskConfig = this.taskScheduler.createTaskConfigurationInstance("repository.rebuild-index");
            taskConfig.setString("repositoryName", "*");
            this.taskScheduler.submit(taskConfig);
        }
        catch (RuntimeException e) {
            this.log.warn("Problem scheduling rebuild of repository indexes", (Throwable)e);
        }
    }

    private boolean allIndicesEmpty() {
        return StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).filter(this::supportsSearch).allMatch(this.elasticSearchIndexService::indexEmpty);
    }

    private boolean supportsSearch(Repository repository) {
        return repository.optionalFacet(SearchIndexFacet.class).isPresent();
    }
}

