/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.index;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.search.index.IndexNamingPolicy;

@Named
@Singleton
public class HashedNamingPolicy
implements IndexNamingPolicy {
    private final LoadingCache<String, String> cachedNames = CacheBuilder.newBuilder().weakKeys().build(CacheLoader.from(HashedNamingPolicy::hashedName));

    @Override
    public String indexName(Repository repository) {
        return (String)this.cachedNames.getUnchecked((Object)repository.getName());
    }

    private static String hashedName(String repositoryName) {
        return HashAlgorithm.SHA1.function().hashUnencodedChars((CharSequence)repositoryName).toString();
    }
}

