/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationStore;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryConditionBuilder;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryContributionSupport;

@Named
@Singleton
public class SqlSearchRepositoryNameUtil
extends ComponentSupport {
    public static final String SPACE = " ";
    private static final String DEFAULT_REGEX = "[^\\s\"]+|\"[^\"]+\"";
    private static final Pattern PATTERN = Pattern.compile("[^\\s\"]+|\"[^\"]+\"");
    private final RepositoryManager repositoryManager;
    private final ConfigurationStore configurationStore;

    @Inject
    public SqlSearchRepositoryNameUtil(RepositoryManager repositoryManager, ConfigurationStore configurationStore) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.configurationStore = (ConfigurationStore)Preconditions.checkNotNull((Object)configurationStore);
    }

    public Set<String> getRepositoryNames(@Nullable String repositoryNameFilter) {
        Set repositories = Optional.ofNullable(repositoryNameFilter).map(this::split).orElse(new HashSet());
        Set<String> wildcards = this.getWildcardRepositoryNames(repositories);
        if (!wildcards.isEmpty()) {
            repositories.removeAll(wildcards);
            repositories.addAll(this.getMatchingRepositoryNames(wildcards));
        }
        return Collections.unmodifiableSet(this.expandRepositories(repositories));
    }

    public Set<String> getFormatRepositoryNames(String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.expandRepositories(this.getFormatRepositories(format)));
    }

    private Set<String> getMatchingRepositoryNames(Set<String> wildcards) {
        return this.configurationStore.readByNames(SqlSearchQueryConditionBuilder.replaceWildcards(wildcards)).stream().map(Configuration::getRepositoryName).collect(Collectors.toSet());
    }

    private Set<String> getWildcardRepositoryNames(Set<String> repositories) {
        return repositories.stream().filter(SqlSearchQueryConditionBuilder::isWildcard).collect(Collectors.toSet());
    }

    private Set<String> getFormatRepositories(String format) {
        return StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).filter(repository -> repository.getFormat().getValue().equals(format)).map(Repository::getName).collect(Collectors.toSet());
    }

    private Set<String> expandRepositories(Set<String> values) {
        Set<String> repositories = this.getLeafMembers(values);
        repositories.addAll(this.excludeGroupRepositories(values));
        return repositories;
    }

    private Set<String> excludeGroupRepositories(Set<String> values) {
        HashSet<String> repositoryNames = new HashSet<String>();
        for (String repositoryName : values) {
            Repository repository = this.repositoryManager.get(repositoryName);
            if (repository != null && !this.isNotGroupRepository(repository)) continue;
            repositoryNames.add(repositoryName);
        }
        return repositoryNames;
    }

    private boolean isNotGroupRepository(Repository repository) {
        return !this.isGroupRepository(repository);
    }

    private boolean isGroupRepository(Repository repository) {
        return "group".equals(repository.getType().getValue());
    }

    private Set<String> getLeafMembers(Set<String> values) {
        return values.stream().map(arg_0 -> ((RepositoryManager)this.repositoryManager).get(arg_0)).filter(Objects::nonNull).filter(this::isGroupRepository).map(repository -> repository.optionalFacet(GroupFacet.class)).filter(Optional::isPresent).map(Optional::get).map(GroupFacet::leafMembers).flatMap(Collection::stream).map(Repository::getName).collect(Collectors.toSet());
    }

    private Set<String> split(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Collections.emptySet();
        }
        Matcher matcher = PATTERN.matcher(value);
        HashSet<String> matches = new HashSet<String>();
        while (matcher.find()) {
            matches.add(SqlSearchQueryContributionSupport.maybeTrimQuotes(matcher.group()));
        }
        return matches;
    }
}

