/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.rest.SearchFieldSupport;
import org.sonatype.nexus.repository.rest.SearchMappings;
import org.sonatype.nexus.repository.search.query.SearchFilter;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryBuilder;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryCondition;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryConditionBuilder;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryContributionSupport;

@Named(value="datastore_search_keyword")
@Singleton
public class KeywordSqlSearchQueryContribution
extends SqlSearchQueryContributionSupport {
    protected static final String NAME = "datastore_search_keyword";
    private static final List<String> KEYWORD_FIELDS = Arrays.asList("group.raw", "name.raw", "version");
    private static final String SPLIT_REGEX = "[^-,\\s\"]+|\"[^\"]+\"";
    private static final String GAVEC_REGEX = "^(?<group>[^\\s:]+):(?<name>[^\\s:]+)(:(?<version>[^\\s:]+))?(:(?<extension>[^\\s:]+))?(:(?<classifier>[^\\s:]+))?$";
    private static final Pattern GAVEC_SPLITTER = Pattern.compile("^(?<group>[^\\s:]+):(?<name>[^\\s:]+)(:(?<version>[^\\s:]+))?(:(?<extension>[^\\s:]+))?(:(?<classifier>[^\\s:]+))?$");
    private static final Pattern SPLITTER = Pattern.compile("[^-,\\s\"]+|\"[^\"]+\"");

    @Inject
    public KeywordSqlSearchQueryContribution(SqlSearchQueryConditionBuilder sqlSearchQueryConditionBuilder, Map<String, SearchMappings> searchMappings) {
        super(sqlSearchQueryConditionBuilder, searchMappings);
    }

    @Override
    public void contribute(SqlSearchQueryBuilder queryBuilder, SearchFilter searchFilter) {
        if (searchFilter == null) {
            return;
        }
        String value = searchFilter.getValue();
        Matcher gavSearchMatcher = GAVEC_SPLITTER.matcher(value.trim());
        if (gavSearchMatcher.matches()) {
            this.buildGavQuery(queryBuilder, gavSearchMatcher);
        } else {
            queryBuilder.add(this.sqlSearchQueryConditionBuilder.combine(this.buildKeywordQuery(value)));
        }
    }

    private List<SqlSearchQueryCondition> buildKeywordQuery(String value) {
        return KEYWORD_FIELDS.stream().map(field -> new SearchFilter((String)field, value)).map(this::buildQueryCondition).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private String toContains(String value) {
        String zeroOrMore = "*";
        return StringUtils.appendIfMissing((String)StringUtils.prependIfMissing((String)value, (CharSequence)zeroOrMore, (CharSequence[])new CharSequence[0]), (CharSequence)zeroOrMore, (CharSequence[])new CharSequence[0]);
    }

    private void buildGavQuery(SqlSearchQueryBuilder queryBuilder, Matcher gavSearchMatcher) {
        this.addMavenAttribute(queryBuilder, "attributes.maven2.groupId", gavSearchMatcher.group("group"));
        this.addMavenAttribute(queryBuilder, "attributes.maven2.artifactId", gavSearchMatcher.group("name"));
        this.addMavenAttribute(queryBuilder, "attributes.maven2.baseVersion", gavSearchMatcher.group("version"));
        this.addMavenAttribute(queryBuilder, "assets.attributes.maven2.extension", gavSearchMatcher.group("extension"));
        this.addMavenAttribute(queryBuilder, "assets.attributes.maven2.classifier", gavSearchMatcher.group("classifier"));
    }

    private void addMavenAttribute(SqlSearchQueryBuilder queryBuilder, String attribute, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            queryBuilder.add(this.sqlSearchQueryConditionBuilder.condition(this.getColumnName(attribute), value));
        }
    }

    private String getColumnName(String attribute) {
        return ((SearchFieldSupport)this.fieldMappings.get(attribute)).getColumnName();
    }

    @Override
    protected Set<String> split(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return new HashSet<String>();
        }
        Matcher matcher = SPLITTER.matcher(value);
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            matches.add(this.toContains(KeywordSqlSearchQueryContribution.maybeTrimQuotes(matcher.group())));
        }
        return new HashSet<String>(matches);
    }
}

