/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import com.google.common.base.Preconditions;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonatype.nexus.repository.search.AssetSearchResult;

public class ComponentSearchResult {
    private String id;
    private String repositoryName;
    private String group;
    private String name;
    private String version;
    private String format;
    private OffsetDateTime lastDownloaded;
    private OffsetDateTime lastModified;
    private List<AssetSearchResult> assets;
    private Map<String, Object> annotations = new HashMap<String, Object>();

    public void addAnnotation(String id, Object annotation) {
        Preconditions.checkArgument((!this.annotations.containsKey(id) ? 1 : 0) != 0, (Object)("Annotation " + id + " already exists on the component."));
        this.annotations.put(id, annotation);
    }

    public Object getAnnotation(String id) {
        return this.annotations.get(id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public List<AssetSearchResult> getAssets() {
        return this.assets;
    }

    public void setAssets(List<AssetSearchResult> assets) {
        this.assets = assets;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified;
    }

    public OffsetDateTime getLastDownloaded() {
        return this.lastDownloaded;
    }

    public void setLastDownloaded(OffsetDateTime lastDownloaded) {
        this.lastDownloaded = lastDownloaded;
    }

    public void addAsset(AssetSearchResult asset) {
        if (this.assets == null) {
            this.assets = new ArrayList<AssetSearchResult>();
        }
        this.assets.add(asset);
    }

    public String toString() {
        return "ComponentSearchResult [id=" + this.id + ", repositoryName=" + this.repositoryName + ", group=" + this.group + ", name=" + this.name + ", version=" + this.version + ", format=" + this.format + ", lastDownloaded=" + this.lastDownloaded + ", lastModified=" + this.lastModified + ", assets=" + this.assets + ", annotations=" + this.annotations + "]";
    }
}

