/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.routing.internal;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.routing.RoutingMode;
import org.sonatype.nexus.repository.routing.RoutingRule;
import org.sonatype.nexus.repository.routing.RoutingRuleHelper;
import org.sonatype.nexus.repository.routing.internal.RoutingRuleCache;
import org.sonatype.nexus.repository.security.RepositoryAdminPermission;
import org.sonatype.nexus.repository.security.RepositoryPermissionChecker;

@Named
@Singleton
public class RoutingRuleHelperImpl
implements RoutingRuleHelper {
    private final RoutingRuleCache routingRuleCache;
    private final RepositoryManager repositoryManager;
    private final RepositoryPermissionChecker repositoryPermissionChecker;
    private volatile List<Permission> repositoryAddPermissions;

    @Inject
    public RoutingRuleHelperImpl(RoutingRuleCache routingRuleCache, RepositoryManager repositoryManager, RepositoryPermissionChecker repositoryPermissionChecker) {
        this.routingRuleCache = (RoutingRuleCache)((Object)Preconditions.checkNotNull((Object)((Object)routingRuleCache)));
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.repositoryPermissionChecker = (RepositoryPermissionChecker)((Object)Preconditions.checkNotNull((Object)((Object)repositoryPermissionChecker)));
    }

    public boolean isAllowed(Repository repository, String path) {
        RoutingRule routingRule = this.routingRuleCache.getRoutingRule(repository);
        if (routingRule == null) {
            return true;
        }
        return this.isAllowed(routingRule, path);
    }

    public boolean isAllowed(RoutingRule routingRule, String path) {
        return this.isAllowed(routingRule.mode(), routingRule.matchers(), path);
    }

    public boolean isAllowed(RoutingMode mode, List<String> matchers, String path) {
        boolean matches = matchers.stream().anyMatch(path::matches);
        return !matches && mode == RoutingMode.BLOCK || matches && mode == RoutingMode.ALLOW;
    }

    public Map<EntityId, List<Repository>> calculateAssignedRepositories() {
        return StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).filter(repository -> this.routingRuleCache.getRoutingRuleId((Repository)repository) != null).collect(Collectors.groupingBy(this.routingRuleCache::getRoutingRuleId, Collectors.toList()));
    }

    public void ensureUserHasPermissionToRead() {
        List<Permission> permissions = this.getRepositoryAddPermissions();
        if (!permissions.isEmpty()) {
            this.repositoryPermissionChecker.ensureUserHasAnyPermissionOrAdminAccess(permissions, "read", this.repositoryManager.browse());
        }
    }

    private List<Permission> getRepositoryAddPermissions() {
        if (this.repositoryAddPermissions == null) {
            this.repositoryAddPermissions = this.repositoryManager.getAllSupportedRecipes().stream().filter(r -> r.getType().getValue().equals("proxy")).map(r -> new RepositoryAdminPermission(r.getFormat().getValue(), "*", Collections.singletonList("add"))).collect(Collectors.toList());
        }
        return this.repositoryAddPermissions;
    }
}

