/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.routing.internal;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryDeletedEvent;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;
import org.sonatype.nexus.repository.routing.RoutingRule;
import org.sonatype.nexus.repository.routing.RoutingRuleInvalidatedEvent;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;

@Named
@Singleton
public class RoutingRuleCache
extends ComponentSupport
implements EventAware {
    private final LoadingCache<Repository, Optional<EntityId>> repositoryAssignedCache = CacheBuilder.newBuilder().build((CacheLoader)new RepositoryMappingCacheLoader());
    private final LoadingCache<EntityId, Optional<RoutingRule>> routingRuleCache = CacheBuilder.newBuilder().build((CacheLoader)new RoutingRuleCacheLoader());
    private final RoutingRuleStore routingRuleStore;

    @Inject
    public RoutingRuleCache(RoutingRuleStore routingRuleStore) {
        this.routingRuleStore = (RoutingRuleStore)Preconditions.checkNotNull((Object)routingRuleStore);
    }

    @Nullable
    public RoutingRule getRoutingRule(Repository repository) {
        try {
            return ((Optional)this.repositoryAssignedCache.get((Object)repository)).map(this::getRoutingRule).orElse(null);
        }
        catch (ExecutionException e) {
            this.log.error("An error occurred retrieving the routing rule for repository: {}", (Object)repository.getName(), (Object)e);
            return null;
        }
    }

    @Nullable
    public EntityId getRoutingRuleId(Repository repository) {
        try {
            return ((Optional)this.repositoryAssignedCache.get((Object)repository)).orElse(null);
        }
        catch (ExecutionException e) {
            this.log.error("An error occurred retrieving the routing rule for repository: {}", (Object)repository.getName(), (Object)e);
            return null;
        }
    }

    private RoutingRule getRoutingRule(EntityId id) {
        try {
            return ((Optional)this.routingRuleCache.get((Object)id)).orElse(null);
        }
        catch (ExecutionException e) {
            this.log.error("An error occurred retrieving the routing rule id {}", (Object)id, (Object)e);
            return null;
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(RepositoryDeletedEvent event) {
        this.repositoryAssignedCache.invalidate((Object)event.getRepository());
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(RepositoryUpdatedEvent event) {
        this.repositoryAssignedCache.invalidate((Object)event.getRepository());
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(RoutingRuleInvalidatedEvent event) {
        this.routingRuleCache.invalidate((Object)event.getRoutingRuleId());
    }

    private static class RepositoryMappingCacheLoader
    extends CacheLoader<Repository, Optional<EntityId>> {
        private RepositoryMappingCacheLoader() {
        }

        public Optional<EntityId> load(Repository repository) throws Exception {
            return Optional.ofNullable(repository.getConfiguration().getRoutingRuleId());
        }
    }

    private class RoutingRuleCacheLoader
    extends CacheLoader<EntityId, Optional<RoutingRule>> {
        private RoutingRuleCacheLoader() {
        }

        public Optional<RoutingRule> load(EntityId key) throws Exception {
            return Optional.ofNullable(RoutingRuleCache.this.routingRuleStore.getById(key.getValue()));
        }
    }
}

