/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources.doc;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.sonatype.nexus.repository.rest.api.AssetXO;
import org.sonatype.nexus.repository.rest.api.ComponentXO;
import org.sonatype.nexus.rest.Page;

@Api(value="Search")
public interface SearchResourceDoc {
    public static final String CONTINUATION_TOKEN_DESCRIPTION = "A token returned by a prior request. If present, the next page of results are returned";
    public static final String SORT_DESCRIPTION = "The field to sort the results against, if left empty, a sort based on match weight will be used.";
    public static final String SEARCH_AND_DL_SORT_DESCRIPTION = "The field to sort the results against, if left empty and more than 1 result is returned, the request will fail.";
    public static final String DIRECTION_DESCRIPTION = "The direction to sort records in, defaults to ascending ('asc') for all sort fields, except version, which defaults to descending ('desc')";
    public static final String TIMEOUT_DESCRIPTION = "How long to wait for search results in seconds. If this value is not provided, the system default timeout will be used.";
    public static final String ALLOWABLE_SORT_VALUES = "group, name, version, repository";
    public static final String ALLOWABLE_SORT_DIRECTIONS = "asc, desc";

    @ApiOperation(value="Search components")
    public Page<ComponentXO> search(@ApiParam(value="A token returned by a prior request. If present, the next page of results are returned", allowEmptyValue=true) String var1, @ApiParam(value="The field to sort the results against, if left empty, a sort based on match weight will be used.", allowEmptyValue=true, allowableValues="group, name, version, repository") String var2, @ApiParam(value="The direction to sort records in, defaults to ascending ('asc') for all sort fields, except version, which defaults to descending ('desc')", allowEmptyValue=true, allowableValues="asc, desc") String var3, @ApiParam(value="How long to wait for search results in seconds. If this value is not provided, the system default timeout will be used.", allowEmptyValue=true) Integer var4, @Context UriInfo var5);

    @ApiOperation(value="Search assets")
    public Page<AssetXO> searchAssets(@ApiParam(value="A token returned by a prior request. If present, the next page of results are returned") String var1, @ApiParam(value="The field to sort the results against, if left empty, a sort based on match weight will be used.", allowEmptyValue=true, allowableValues="group, name, version, repository") String var2, @ApiParam(value="The direction to sort records in, defaults to ascending ('asc') for all sort fields, except version, which defaults to descending ('desc')", allowEmptyValue=true, allowableValues="asc, desc") String var3, @ApiParam(value="How long to wait for search results in seconds. If this value is not provided, the system default timeout will be used.", allowEmptyValue=true) Integer var4, @Context UriInfo var5);

    @ApiOperation(value="Search and download asset", notes="Returns a 302 Found with location header field set to download URL. Unless a sort parameter is supplied, the search must return a single asset to receive download URL.")
    @ApiResponses(value={@ApiResponse(code=400, message="Search returned multiple assets, please refine search criteria to find a single asset or use the sort query parameter to retrieve the first result."), @ApiResponse(code=404, message="Asset search returned no results")})
    public Response searchAndDownloadAssets(@ApiParam(value="The field to sort the results against, if left empty and more than 1 result is returned, the request will fail.", allowEmptyValue=true, allowableValues="group, name, version, repository") String var1, @ApiParam(value="The direction to sort records in, defaults to ascending ('asc') for all sort fields, except version, which defaults to descending ('desc')", allowEmptyValue=true, allowableValues="asc, desc") String var2, @ApiParam(value="How long to wait for search results in seconds. If this value is not provided, the system default timeout will be used.", allowEmptyValue=true) Integer var3, @Context UriInfo var4);
}

