/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.rest.api.AuthorizingRepositoryManager;
import org.sonatype.nexus.repository.rest.internal.resources.ProprietaryContentRequest;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.validation.Validate;

@Named
@Singleton
@Path(value="/internal/proprietary-content")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RepositoryProprietaryContentResource
extends ComponentSupport
implements Resource {
    public static final String RESOURCE_URI = "/internal/proprietary-content";
    private final AuthorizingRepositoryManager repositoryManager;

    @Inject
    public RepositoryProprietaryContentResource(AuthorizingRepositoryManager repositoryManager) {
        this.repositoryManager = (AuthorizingRepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    @GET
    public List<String> get() {
        return this.repositoryManager.getRepositoriesWithAdmin().stream().filter(repository -> (Boolean)repository.getConfiguration().attributes("component").get("proprietaryComponents", Boolean.class, (Object)false)).map(Repository::getName).collect(Collectors.toList());
    }

    @RequiresAuthentication
    @POST
    @Validate
    public void set(@NotNull @Valid ProprietaryContentRequest request) {
        ArrayList failed = Lists.newArrayList();
        request.getProprietary().stream().map(this.repositoryManager::getRepositoryWithAdmin).filter(Optional::isPresent).map(Optional::get).filter(this::isHostedRepository).forEach(repository -> {
            Configuration configuration = repository.getConfiguration().copy();
            configuration.attributes("component").set("proprietaryComponents", (Object)true);
            String repositoryName = repository.getName();
            try {
                this.repositoryManager.update(configuration);
                this.log.info("Marked '{}' repository as source of proprietary content", (Object)repositoryName);
            }
            catch (Exception e) {
                this.log.error("Failed to mark '{}' repository as source of proprietary content, {}", (Object)repositoryName, this.log.isDebugEnabled() ? e : e.getMessage());
                failed.add(repositoryName);
            }
        });
        request.getNonProprietary().stream().map(this.repositoryManager::getRepositoryWithAdmin).filter(Optional::isPresent).map(Optional::get).filter(this::isHostedRepository).forEach(repository -> {
            Configuration configuration = repository.getConfiguration().copy();
            configuration.attributes("component").set("proprietaryComponents", (Object)false);
            String repositoryName = repository.getName();
            try {
                this.repositoryManager.update(configuration);
                this.log.info("Unmarked '{}' repository as source of proprietary content", (Object)repositoryName);
            }
            catch (Exception e) {
                this.log.error("Failed to unmark '{}' repository as source of proprietary content, {}", (Object)repositoryName, this.log.isDebugEnabled() ? e : e.getMessage());
                failed.add(repositoryName);
            }
        });
        if (!failed.isEmpty()) {
            throw new WebApplicationMessageException(Response.Status.INTERNAL_SERVER_ERROR, (Object)("\"Problem updating following repositories: " + Joiner.on((String)", ").join((Iterable)failed) + "\""), "application/json");
        }
    }

    private boolean isHostedRepository(Repository repository) {
        if (!"hosted".equals(repository.getType().getValue())) {
            this.log.warn("Repository {} is not a hosted repository, proprietary component flag is not valid for non-hosted repositories", (Object)repository.getName());
            return false;
        }
        return true;
    }
}

