/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Recipe;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationStore;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.rest.api.RepositoryManagerRESTAdapter;
import org.sonatype.nexus.repository.rest.api.RepositoryXO;
import org.sonatype.nexus.repository.security.RepositoryPermissionChecker;
import org.sonatype.nexus.repository.types.ProxyType;

@Named
public class RepositoryManagerRESTAdapterImpl
extends ComponentSupport
implements RepositoryManagerRESTAdapter {
    private final RepositoryManager repositoryManager;
    private final ConfigurationStore configurationStore;
    private final Map<String, Recipe> recipes;
    private final RepositoryPermissionChecker repositoryPermissionChecker;

    @Inject
    public RepositoryManagerRESTAdapterImpl(RepositoryManager repositoryManager, ConfigurationStore configurationStore, Map<String, Recipe> recipes, RepositoryPermissionChecker repositoryPermissionChecker) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.configurationStore = (ConfigurationStore)Preconditions.checkNotNull((Object)configurationStore);
        this.recipes = (Map)Preconditions.checkNotNull(recipes);
        this.repositoryPermissionChecker = (RepositoryPermissionChecker)((Object)Preconditions.checkNotNull((Object)((Object)repositoryPermissionChecker)));
    }

    @Override
    public Repository getRepository(String repositoryId) {
        if (repositoryId == null) {
            throw new WebApplicationException("repositoryId is required.", 422);
        }
        Repository repository = Optional.ofNullable(this.repositoryManager.get(repositoryId)).orElseThrow(() -> new NotFoundException("Unable to locate repository with id " + repositoryId));
        if (this.repositoryPermissionChecker.userCanReadOrBrowse(repository)) {
            return repository;
        }
        throw new WebApplicationException(403);
    }

    @Override
    public Repository getReadableRepository(String repositoryId) {
        if (repositoryId == null) {
            throw new WebApplicationException("repositoryId is required.", 422);
        }
        Repository repository = Optional.ofNullable(this.repositoryManager.get(repositoryId)).orElseThrow(() -> new NotFoundException("Unable to locate repository with id " + repositoryId));
        if (!this.userCanReadOrBrowseOrGroupPermissions(repository)) {
            throw new WebApplicationException(403);
        }
        return repository;
    }

    private boolean userCanReadOrBrowseOrGroupPermissions(Repository repository) {
        ArrayList<String> repositories = new ArrayList<String>(this.repositoryManager.findContainingGroups(repository.getName()));
        repositories.add(repository.getName());
        return repositories.stream().map(arg_0 -> ((RepositoryManager)this.repositoryManager).get(arg_0)).filter(Objects::nonNull).anyMatch(this.repositoryPermissionChecker::userCanReadOrBrowse);
    }

    @Override
    public List<RepositoryXO> getRepositories() {
        Configuration[] configurations = this.configurationStore.list().toArray(new Configuration[0]);
        return this.repositoryPermissionChecker.userCanBrowseRepositories(configurations).stream().map(this::asRepository).collect(Collectors.toList());
    }

    @Override
    public List<String> findContainingGroups(String repositoryName) {
        return this.repositoryManager.findContainingGroups(repositoryName);
    }

    private Type getType(Configuration configuration) {
        Recipe recipe = this.recipes.get(configuration.getRecipeName());
        return recipe.getType();
    }

    private Format getFormat(Configuration configuration) {
        Recipe recipe = this.recipes.get(configuration.getRecipeName());
        return recipe.getFormat();
    }

    private static String getUrl(String repositoryName) {
        return String.valueOf(BaseUrlHolder.get()) + "/repository/" + repositoryName;
    }

    private Map<String, Object> attributes(Configuration configuration) {
        NestedAttributesMap attrs;
        if (this.getType(configuration) instanceof ProxyType && (attrs = configuration.attributes("proxy")) != null) {
            Object remoteUrl = attrs.get("remoteUrl", (Object)"");
            return Collections.singletonMap("proxy", Collections.singletonMap("remoteUrl", remoteUrl));
        }
        return Collections.emptyMap();
    }

    private RepositoryXO asRepository(Configuration configuration) {
        RepositoryXO xo = new RepositoryXO();
        String repositoryName = configuration.getRepositoryName();
        Type type = this.getType(configuration);
        xo.setName(repositoryName);
        xo.setType(type.getValue());
        xo.setFormat(this.getFormat(configuration).getValue());
        xo.setUrl(RepositoryManagerRESTAdapterImpl.getUrl(repositoryName));
        xo.setAttributes(this.attributes(configuration));
        return xo;
    }
}

