/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.sonatype.nexus.repository.rest.api.RepositoryManagerRESTAdapter;
import org.sonatype.nexus.repository.rest.api.RepositoryXO;
import org.sonatype.nexus.repository.rest.internal.resources.doc.RepositoriesResourceDoc;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/v1/repositories")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class RepositoriesResource
implements Resource,
RepositoriesResourceDoc {
    public static final String RESOURCE_URI = "/v1/repositories";
    private final RepositoryManagerRESTAdapter repositoryManagerRESTAdapter;

    @Inject
    public RepositoriesResource(RepositoryManagerRESTAdapter repositoryManagerRESTAdapter) {
        this.repositoryManagerRESTAdapter = (RepositoryManagerRESTAdapter)Preconditions.checkNotNull((Object)repositoryManagerRESTAdapter);
    }

    @Override
    @GET
    public List<RepositoryXO> getRepositories() {
        return this.repositoryManagerRESTAdapter.getRepositories();
    }

    @Override
    @GET
    @Path(value="/{repositoryName}")
    public RepositoryXO getRepository(@PathParam(value="repositoryName") String repositoryName) {
        return RepositoryXO.fromRepository(this.repositoryManagerRESTAdapter.getReadableRepository(repositoryName));
    }
}

