/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.nexus.repository.rest.api.ContentSelectorApiCreateRequest;
import org.sonatype.nexus.repository.rest.api.ContentSelectorApiResponse;
import org.sonatype.nexus.repository.rest.api.ContentSelectorApiUpdateRequest;
import org.sonatype.nexus.repository.rest.internal.resources.doc.ContentSelectorsResourceDoc;
import org.sonatype.nexus.rest.NotCacheable;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorFactory;
import org.sonatype.nexus.selector.SelectorManager;
import org.sonatype.nexus.validation.Validate;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ContentSelectorsApiResource
implements Resource,
ContentSelectorsResourceDoc {
    private final SelectorFactory selectorFactory;
    private final SelectorManager selectorManager;

    @Inject
    public ContentSelectorsApiResource(SelectorFactory selectorFactory, SelectorManager selectorManager) {
        this.selectorFactory = (SelectorFactory)Preconditions.checkNotNull((Object)selectorFactory);
        this.selectorManager = (SelectorManager)Preconditions.checkNotNull((Object)selectorManager);
    }

    @Override
    @GET
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:selectors:read"})
    @NotCacheable
    public List<ContentSelectorApiResponse> getContentSelectors() {
        return this.selectorManager.browse().stream().map(ContentSelectorsApiResource::fromSelectorConfiguration).collect(Collectors.toList());
    }

    @Override
    @POST
    @RequiresAuthentication
    @Validate
    @RequiresPermissions(value={"nexus:selectors:create"})
    public void createContentSelector(@Valid ContentSelectorApiCreateRequest request) {
        this.selectorFactory.validateSelector("csel", request.getExpression());
        this.selectorManager.create(request.getName(), "csel", request.getDescription(), Collections.singletonMap("expression", request.getExpression()));
    }

    @Override
    @GET
    @Path(value="{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:selectors:read"})
    public ContentSelectorApiResponse getContentSelector(@PathParam(value="name") String name) {
        SelectorConfiguration configuration = this.findConfigurationByNameOrThrowNotFound(name);
        return ContentSelectorsApiResource.fromSelectorConfiguration(configuration);
    }

    @Override
    @PUT
    @Path(value="{name}")
    @RequiresAuthentication
    @Validate
    @RequiresPermissions(value={"nexus:selectors:update"})
    public void updateContentSelector(@PathParam(value="name") String name, @Valid ContentSelectorApiUpdateRequest request) {
        SelectorConfiguration configuration = this.findConfigurationByNameOrThrowNotFound(name);
        this.selectorFactory.validateSelector(configuration.getType(), request.getExpression());
        configuration.setDescription(request.getDescription());
        configuration.setAttributes(Collections.singletonMap("expression", request.getExpression()));
        this.selectorManager.update(configuration);
    }

    @Override
    @DELETE
    @Path(value="{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:selectors:delete"})
    public void deleteContentSelector(@PathParam(value="name") String name) {
        SelectorConfiguration configuration = this.findConfigurationByNameOrThrowNotFound(name);
        this.selectorManager.delete(configuration);
    }

    private SelectorConfiguration findConfigurationByNameOrThrowNotFound(String name) {
        return (SelectorConfiguration)this.selectorManager.findByName(name).orElseThrow(() -> new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)("\"No selector found for " + name + '\"'), "application/json"));
    }

    private static ContentSelectorApiResponse fromSelectorConfiguration(SelectorConfiguration selectorConfiguration) {
        ContentSelectorApiResponse response = new ContentSelectorApiResponse();
        response.setName(selectorConfiguration.getName());
        response.setType(selectorConfiguration.getType());
        response.setDescription(selectorConfiguration.getDescription());
        response.setExpression((String)selectorConfiguration.getAttributes().get("expression"));
        return response;
    }
}

