/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.MultivaluedMap;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.SearchUtils;

@Named
@Singleton
class AssetMapUtils {
    private static final String EMPTY_PARAM = "";
    private final SearchUtils searchUtils;

    @Inject
    public AssetMapUtils(SearchUtils searchUtils) {
        this.searchUtils = (SearchUtils)((Object)Preconditions.checkNotNull((Object)((Object)searchUtils)));
    }

    static Optional<Object> getValueFromAssetMap(AssetSearchResult asset, String identifier) {
        if (Strings.isNullOrEmpty((String)identifier)) {
            return Optional.empty();
        }
        ArrayList keys = Lists.newArrayList((Object[])identifier.split("\\."));
        if ("assets".equals(keys.get(0))) {
            keys.remove(0);
        }
        switch ((String)keys.get(0)) {
            case "contentType": {
                return Optional.of(asset.getContentType());
            }
            case "format": {
                return Optional.of(asset.getFormat());
            }
            case "id": {
                return Optional.of(asset.getId());
            }
            case "path": {
                return Optional.of(asset.getPath());
            }
        }
        Map<String, String> value = Collections.emptyMap();
        if (!keys.isEmpty() && "attributes".equals(keys.get(0))) {
            keys.remove(0);
            value = asset.getAttributes();
            if (!keys.isEmpty() && "checksum".equals(keys.get(0))) {
                keys.remove(0);
                value = asset.getChecksum();
            }
        }
        for (String key : keys) {
            if (value == null) {
                return Optional.empty();
            }
            value = value.get(key);
        }
        return Optional.ofNullable(value);
    }

    @VisibleForTesting
    boolean filterAsset(AssetSearchResult asset, MultivaluedMap<String, String> assetParams) {
        if (AssetMapUtils.excludeAsset(asset, this.getEmptyAssetParams(assetParams))) {
            return false;
        }
        Map<String, String> assetParamsWithValues = this.getNonEmptyAssetParams(assetParams);
        if (assetParamsWithValues.isEmpty()) {
            return true;
        }
        return assetParamsWithValues.entrySet().stream().allMatch(entry -> AssetMapUtils.keepAsset(asset, (String)entry.getKey(), (String)entry.getValue()));
    }

    static boolean excludeAsset(AssetSearchResult asset, List<String> paramFilters) {
        return paramFilters.stream().anyMatch(filter -> AssetMapUtils.getValueFromAssetMap(asset, filter).isPresent());
    }

    static boolean keepAsset(AssetSearchResult asset, String paramKey, String paramValue) {
        return AssetMapUtils.getValueFromAssetMap(asset, paramKey).map(result -> result.equals(paramValue)).orElse(false);
    }

    @VisibleForTesting
    List<String> getEmptyAssetParams(MultivaluedMap<String, String> assetParams) {
        return assetParams.entrySet().stream().filter(entry -> EMPTY_PARAM.equals(((List)entry.getValue()).get(0))).map(e -> this.searchUtils.getFullAssetAttributeName((String)e.getKey())).collect(Collectors.toList());
    }

    @VisibleForTesting
    Map<String, String> getNonEmptyAssetParams(MultivaluedMap<String, String> assetParams) {
        return assetParams.entrySet().stream().filter(entry -> !EMPTY_PARAM.equals(((List)entry.getValue()).get(0))).collect(Collectors.toMap(entry -> this.searchUtils.getFullAssetAttributeName((String)entry.getKey()), entry -> (String)((List)entry.getValue()).get(0)));
    }
}

