/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Recipe;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.httpclient.RemoteConnectionStatus;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.rest.api.ApiRepositoryAdapter;
import org.sonatype.nexus.repository.rest.api.AuthorizingRepositoryManager;
import org.sonatype.nexus.repository.rest.api.model.AbstractApiRepository;
import org.sonatype.nexus.repository.rest.internal.api.RecipeXO;
import org.sonatype.nexus.repository.rest.internal.api.RepositoryDetailXO;
import org.sonatype.nexus.repository.rest.internal.api.RepositoryNugetXO;
import org.sonatype.nexus.repository.rest.internal.api.RepositoryStatusXO;
import org.sonatype.nexus.repository.rest.internal.api.RepositoryXO;
import org.sonatype.nexus.repository.security.RepositoryPermissionChecker;
import org.sonatype.nexus.repository.security.RepositorySelector;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="internal/ui/repositories")
public class RepositoryInternalResource
extends ComponentSupport
implements Resource {
    static final String RESOURCE_PATH = "internal/ui/repositories";
    static final RepositoryXO ALL_REFERENCE = new RepositoryXO(RepositorySelector.all().toSelector(), "(All Repositories)");
    static final String ALL_FORMATS = "*";
    private final List<Format> formats;
    private final RepositoryManager repositoryManager;
    private final RepositoryPermissionChecker repositoryPermissionChecker;
    private final ProxyType proxyType;
    private final List<Recipe> recipes;
    private final AuthorizingRepositoryManager authorizingRepositoryManager;
    private final Map<String, ApiRepositoryAdapter> convertersByFormat;
    private final ApiRepositoryAdapter defaultAdapter;

    @Inject
    public RepositoryInternalResource(List<Format> formats, RepositoryManager repositoryManager, RepositoryPermissionChecker repositoryPermissionChecker, ProxyType proxyType, List<Recipe> recipes, AuthorizingRepositoryManager authorizingRepositoryManager, Map<String, ApiRepositoryAdapter> convertersByFormat, @Named(value="default") ApiRepositoryAdapter defaultAdapter) {
        this.formats = (List)Preconditions.checkNotNull(formats);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.repositoryPermissionChecker = (RepositoryPermissionChecker)((Object)Preconditions.checkNotNull((Object)((Object)repositoryPermissionChecker)));
        this.proxyType = (ProxyType)Preconditions.checkNotNull((Object)proxyType);
        this.recipes = (List)Preconditions.checkNotNull(recipes);
        this.authorizingRepositoryManager = (AuthorizingRepositoryManager)Preconditions.checkNotNull((Object)authorizingRepositoryManager);
        this.convertersByFormat = (Map)Preconditions.checkNotNull(convertersByFormat);
        this.defaultAdapter = (ApiRepositoryAdapter)Preconditions.checkNotNull((Object)defaultAdapter);
    }

    @GET
    @RequiresAuthentication
    public List<RepositoryXO> getRepositories(@QueryParam(value="type") String type, @QueryParam(value="withAll") boolean withAll, @QueryParam(value="withFormats") boolean withFormats, @QueryParam(value="format") String formatParam) {
        List repositories = this.repositoryPermissionChecker.userCanBrowseRepositories(this.repositoryManager.browse()).stream().filter(repository -> StringUtils.isBlank((CharSequence)type) || type.equals(repository.getType().getValue())).filter(repository -> StringUtils.isBlank((CharSequence)formatParam) || formatParam.equals(ALL_FORMATS) || formatParam.equals(repository.getFormat().getValue())).map(this::asRepository).sorted(Comparator.comparing(RepositoryXO::getName)).collect(Collectors.toList());
        ArrayList<RepositoryXO> result = new ArrayList<RepositoryXO>();
        if (withAll) {
            result.add(ALL_REFERENCE);
        }
        if (withFormats) {
            this.formats.stream().map(format -> new RepositoryXO(RepositorySelector.allOfFormat(format.getValue()).toSelector(), "(All " + format.getValue() + " Repositories)")).sorted(Comparator.comparing(RepositoryXO::getName)).forEach(result::add);
        }
        result.addAll(repositories);
        return result;
    }

    @GET
    @Path(value="/repository/{repositoryName}")
    @RequiresAuthentication
    public AbstractApiRepository getRepository(@PathParam(value="repositoryName") String repositoryName) {
        return this.authorizingRepositoryManager.getRepositoryWithAdmin(repositoryName).map(repository -> this.convertersByFormat.getOrDefault(repository.getFormat().getValue(), this.defaultAdapter).adapt((Repository)repository)).get();
    }

    @GET
    @Path(value="/details")
    public List<RepositoryDetailXO> getRepositoryDetails() {
        return Streams.stream((Iterable)this.repositoryManager.browse()).filter(repository -> this.repositoryPermissionChecker.userHasRepositoryAdminPermission((Repository)repository, "read")).map(this::asRepositoryDetail).collect(Collectors.toList());
    }

    @GET
    @Path(value="/recipes")
    public List<RecipeXO> getRecipes() {
        return this.recipes.stream().filter(Recipe::isFeatureEnabled).map(RecipeXO::new).collect(Collectors.toList());
    }

    private RepositoryDetailXO asRepositoryDetail(Repository repository) {
        boolean online = repository.getConfiguration().isOnline();
        String description = null;
        String reason = null;
        if (this.proxyType.equals((Object)repository.getType())) {
            HttpClientFacet httpClientFacet = (HttpClientFacet)repository.facet(HttpClientFacet.class);
            RemoteConnectionStatus remoteConnectionStatus = httpClientFacet.getStatus();
            description = remoteConnectionStatus.getDescription();
            reason = remoteConnectionStatus.getReason();
        }
        return new RepositoryDetailXO(repository.getName(), repository.getType().toString(), repository.getFormat().toString(), repository.getUrl(), new RepositoryStatusXO(online, description, reason));
    }

    private RepositoryXO asRepository(Repository repository) {
        String format = repository.getFormat().getValue();
        String name = repository.getName();
        return format.equals("nuget") ? this.asNugetRepository(repository) : new RepositoryXO(name, name);
    }

    private RepositoryXO asNugetRepository(Repository repository) {
        String name = repository.getName();
        String type = repository.getType().getValue();
        String nugetVersion = null;
        Collection memberNames = null;
        if (type.equals("proxy")) {
            nugetVersion = (String)repository.getConfiguration().attributes("nugetProxy").get("nugetVersion");
        } else if (type.equals("group")) {
            memberNames = (Collection)repository.getConfiguration().attributes("group").get("memberNames");
        } else {
            return new RepositoryXO(name, name);
        }
        return new RepositoryNugetXO(name, name, nugetVersion, memberNames);
    }
}

