/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.api;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.RepositoryCacheInvalidationService;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.rest.api.AuthorizingRepositoryManager;
import org.sonatype.nexus.repository.rest.api.IncompatibleRepositoryException;
import org.sonatype.nexus.repository.rest.api.RepositoryNotFoundException;
import org.sonatype.nexus.repository.security.RepositoryPermissionChecker;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;

@Named
@Singleton
public class AuthorizingRepositoryManagerImpl
implements AuthorizingRepositoryManager {
    private final RepositoryManager repositoryManager;
    private final RepositoryPermissionChecker repositoryPermissionChecker;
    private final TaskScheduler taskScheduler;
    private final RepositoryCacheInvalidationService repositoryCacheInvalidationService;

    @Inject
    public AuthorizingRepositoryManagerImpl(RepositoryManager repositoryManager, RepositoryPermissionChecker repositoryPermissionChecker, TaskScheduler taskScheduler, RepositoryCacheInvalidationService repositoryCacheInvalidationService) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.repositoryPermissionChecker = (RepositoryPermissionChecker)((Object)Preconditions.checkNotNull((Object)((Object)repositoryPermissionChecker)));
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.repositoryCacheInvalidationService = (RepositoryCacheInvalidationService)Preconditions.checkNotNull((Object)repositoryCacheInvalidationService);
    }

    @Override
    public void create(@Nonnull Configuration configuration) throws Exception {
        String format = configuration.getRecipeName().split("-")[0];
        this.repositoryPermissionChecker.ensureUserCanAdmin("add", format, configuration.getRepositoryName());
        this.repositoryManager.create(configuration);
    }

    @Override
    public boolean update(@Nonnull Configuration configuration) throws Exception {
        Repository repository = this.repositoryManager.get(configuration.getRepositoryName());
        if (repository != null) {
            this.repositoryPermissionChecker.ensureUserCanAdmin("edit", repository);
            Configuration updatedConfig = repository.getConfiguration().copy();
            updatedConfig.setRoutingRuleId(configuration.getRoutingRuleId());
            updatedConfig.setOnline(configuration.isOnline());
            updatedConfig.setAttributes(configuration.getAttributes());
            this.repositoryManager.update(updatedConfig);
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(@Nonnull String name) throws Exception {
        Repository repository = this.repositoryManager.get(name);
        if (repository != null) {
            this.repositoryPermissionChecker.ensureUserCanAdmin("delete", repository);
            this.repositoryManager.delete(repository.getName());
            return true;
        }
        return false;
    }

    @Override
    public List<Repository> getRepositoriesWithAdmin() {
        return this.repositoryPermissionChecker.userHasRepositoryAdminPermission(this.repositoryManager.browse(), "read");
    }

    @Override
    public Optional<Repository> getRepositoryWithAdmin(String repositoryName) {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository == null) {
            return Optional.empty();
        }
        return this.repositoryPermissionChecker.userHasRepositoryAdminPermission(Collections.singletonList(repository), "read").stream().findFirst();
    }

    private void ensureHostedOrProxy(Repository repository) throws IncompatibleRepositoryException {
        String type = repository.getType().getValue();
        if (!type.equals("hosted") && !type.equals("proxy")) {
            throw new IncompatibleRepositoryException("You can rebuild search index of hosted or proxy repository only");
        }
    }

    @Override
    public void rebuildSearchIndex(@Nonnull String name) throws RepositoryNotFoundException, IncompatibleRepositoryException {
        Repository repository = this.getEditableRepositoryOrThrow(name);
        this.ensureHostedOrProxy(repository);
        TaskConfiguration taskConfiguration = this.taskScheduler.createTaskConfigurationInstance("repository.rebuild-index");
        taskConfiguration.setString("repositoryName", name);
        this.taskScheduler.submit(taskConfiguration);
    }

    @Override
    public void invalidateCache(@Nonnull String name) throws RepositoryNotFoundException, IncompatibleRepositoryException {
        Repository repository = this.getEditableRepositoryOrThrow(name);
        this.ensureProxyOrGroup(repository);
        this.repositoryCacheInvalidationService.processCachesInvalidation(repository);
    }

    private void ensureProxyOrGroup(Repository repository) throws IncompatibleRepositoryException {
        String type = repository.getType().getValue();
        if (!type.equals("proxy") && !type.equals("group")) {
            throw new IncompatibleRepositoryException("You can invalidate cache of proxy or group repository only");
        }
    }

    private Repository getEditableRepositoryOrThrow(@Nonnull String name) throws RepositoryNotFoundException {
        Repository repository = this.repositoryManager.get(name);
        if (repository == null) {
            throw new RepositoryNotFoundException();
        }
        this.repositoryPermissionChecker.ensureUserCanAdmin("edit", repository);
        return repository;
    }
}

