/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal;

import com.google.common.collect.ImmutableList;
import io.swagger.models.HttpMethod;
import io.swagger.models.parameters.FormParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadManager;
import org.sonatype.nexus.swagger.ParameterContributor;

@Named
@Singleton
public class ComponentUploadParameterContributor
extends ParameterContributor<FormParameter> {
    private static final List<HttpMethod> HTTP_METHODS = ImmutableList.of((Object)HttpMethod.POST);
    private static final List<String> PATHS = ImmutableList.of((Object)"/v1/components");

    @Inject
    public ComponentUploadParameterContributor(UploadManager uploadManager) {
        super(HTTP_METHODS, PATHS, ComponentUploadParameterContributor.transformUploadDefinitions(uploadManager.getAvailableDefinitions()));
    }

    private static Collection<FormParameter> transformUploadDefinitions(Collection<UploadDefinition> uploadDefinitions) {
        ArrayList<FormParameter> parameters = new ArrayList<FormParameter>();
        for (UploadDefinition uploadDefinition : uploadDefinitions) {
            uploadDefinition.getComponentFields().forEach(uploadFieldDefinition -> {
                boolean bl = parameters.add((FormParameter)((FormParameter)((FormParameter)new FormParameter().name(String.valueOf(uploadDefinition.getFormat()) + "." + uploadFieldDefinition.getName())).type(uploadFieldDefinition.getType().name().toLowerCase())).description(String.valueOf(uploadDefinition.getFormat()) + " " + uploadFieldDefinition.getDisplayName()));
            });
            int i = 1;
            while (i <= (uploadDefinition.isMultipleUpload() ? 3 : 1)) {
                String assetIndex = uploadDefinition.isMultipleUpload() ? Integer.toString(i) : "";
                String assetName = String.valueOf(uploadDefinition.getFormat()) + ".asset" + assetIndex;
                String assetDisplayName = String.valueOf(uploadDefinition.getFormat()) + " Asset " + assetIndex;
                parameters.add((FormParameter)((FormParameter)((FormParameter)new FormParameter().name(assetName)).type("file")).description(assetDisplayName));
                uploadDefinition.getAssetFields().forEach(uploadFieldDefinition -> {
                    boolean bl = parameters.add((FormParameter)((FormParameter)((FormParameter)new FormParameter().name(String.valueOf(assetName) + "." + uploadFieldDefinition.getName())).type(uploadFieldDefinition.getType().name().toLowerCase())).description(String.valueOf(assetDisplayName) + " " + uploadFieldDefinition.getDisplayName()));
                });
                ++i;
            }
        }
        return parameters;
    }
}

