/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public class HttpClientConnectionAttributes {
    @ApiModelProperty(value="Total retries if the initial connection attempt suffers a timeout", example="0", allowableValues="range[0,10]")
    @Min(value=0L)
    @Max(value=10L)
    protected final @Min(value=0L) @Max(value=10L) Integer retries;
    @ApiModelProperty(value="Custom fragment to append to User-Agent header in HTTP requests", example="")
    protected final String userAgentSuffix;
    @ApiModelProperty(value="Seconds to wait for activity before stopping and retrying the connection", example="60", allowableValues="range[1,3600]")
    @Min(value=1L)
    @Max(value=3600L)
    protected final @Min(value=1L) @Max(value=3600L) Integer timeout;
    @ApiModelProperty(value="Whether to enable redirects to the same location (may be required by some servers)", example="false")
    protected final Boolean enableCircularRedirects;
    @ApiModelProperty(value="Whether to allow cookies to be stored and used", example="false")
    protected final Boolean enableCookies;
    @ApiModelProperty(value="Use certificates stored in the Nexus Repository Manager truststore to connect to external systems", example="false")
    protected final Boolean useTrustStore;

    @JsonCreator
    public HttpClientConnectionAttributes(@JsonProperty(value="retries") Integer retries, @JsonProperty(value="userAgentSuffix") String userAgentSuffix, @JsonProperty(value="timeout") Integer timeout, @JsonProperty(value="enableCircularRedirects") Boolean enableCircularRedirects, @JsonProperty(value="enableCookies") Boolean enableCookies, @JsonProperty(value="useTrustStore") Boolean useTrustStore) {
        this.retries = retries;
        this.userAgentSuffix = userAgentSuffix;
        this.timeout = timeout;
        this.enableCircularRedirects = enableCircularRedirects;
        this.enableCookies = enableCookies;
        this.useTrustStore = useTrustStore;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public String getUserAgentSuffix() {
        return this.userAgentSuffix;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Boolean getEnableCircularRedirects() {
        return this.enableCircularRedirects;
    }

    public Boolean getEnableCookies() {
        return this.enableCookies;
    }

    public Boolean getUseTrustStore() {
        return this.useTrustStore;
    }
}

