/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.api;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.rest.api.AuthorizingRepositoryManager;
import org.sonatype.nexus.repository.rest.api.IncompatibleRepositoryException;
import org.sonatype.nexus.repository.rest.api.RepositoriesApiResourceDoc;
import org.sonatype.nexus.repository.rest.api.RepositoryNotFoundException;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class RepositoriesApiResource
extends ComponentSupport
implements Resource,
RepositoriesApiResourceDoc {
    private final AuthorizingRepositoryManager authorizingRepositoryManager;

    @Inject
    public RepositoriesApiResource(AuthorizingRepositoryManager authorizingRepositoryManager) {
        this.authorizingRepositoryManager = (AuthorizingRepositoryManager)Preconditions.checkNotNull((Object)authorizingRepositoryManager);
    }

    @Override
    @DELETE
    @Path(value="/{repositoryName}")
    @RequiresAuthentication
    public Response deleteRepository(@PathParam(value="repositoryName") String repositoryName) throws Exception {
        boolean isDeleted = this.authorizingRepositoryManager.delete(repositoryName);
        return Response.status((Response.Status)(isDeleted ? Response.Status.NO_CONTENT : Response.Status.NOT_FOUND)).build();
    }

    @Override
    @POST
    @Path(value="/{repositoryName}/rebuild-index")
    @RequiresAuthentication
    public void rebuildIndex(@PathParam(value="repositoryName") String repositoryName) {
        try {
            this.authorizingRepositoryManager.rebuildSearchIndex(repositoryName);
        }
        catch (IncompatibleRepositoryException e) {
            this.log.debug("Not a hosted or proxy repository '{}'", (Object)repositoryName, (Object)e);
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)("\"" + e.getMessage() + "\""), "application/json");
        }
        catch (RepositoryNotFoundException e) {
            this.log.debug("Repository not found '{}'", (Object)repositoryName, (Object)e);
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)("\"" + e.getMessage() + "\""), "application/json");
        }
    }

    @Override
    @POST
    @Path(value="/{repositoryName}/invalidate-cache")
    @RequiresAuthentication
    public void invalidateCache(@PathParam(value="repositoryName") String repositoryName) {
        try {
            this.authorizingRepositoryManager.invalidateCache(repositoryName);
        }
        catch (IncompatibleRepositoryException e) {
            this.log.debug("Not a proxy nor group repository '{}'", (Object)repositoryName, (Object)e);
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)("\"" + e.getMessage() + "\""), "application/json");
        }
        catch (RepositoryNotFoundException e) {
            this.log.debug("Repository not found '{}'", (Object)repositoryName, (Object)e);
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)("\"" + e.getMessage() + "\""), "application/json");
        }
    }
}

