/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.api;

import com.google.common.collect.Sets;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.rest.api.AbstractRepositoryApiRequestToConfigurationConverter;
import org.sonatype.nexus.repository.rest.api.model.CleanupPolicyAttributes;
import org.sonatype.nexus.repository.rest.api.model.HttpClientAttributes;
import org.sonatype.nexus.repository.rest.api.model.HttpClientConnectionAttributes;
import org.sonatype.nexus.repository.rest.api.model.HttpClientConnectionAuthenticationAttributes;
import org.sonatype.nexus.repository.rest.api.model.NegativeCacheAttributes;
import org.sonatype.nexus.repository.rest.api.model.ProxyAttributes;
import org.sonatype.nexus.repository.rest.api.model.ProxyRepositoryApiRequest;
import org.sonatype.nexus.repository.rest.api.model.ReplicationAttributes;
import org.sonatype.nexus.repository.rest.api.model.StorageAttributes;
import org.sonatype.nexus.repository.routing.RoutingRule;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;

@Named
public class ProxyRepositoryApiRequestToConfigurationConverter<T extends ProxyRepositoryApiRequest>
extends AbstractRepositoryApiRequestToConfigurationConverter<T> {
    private final RoutingRuleStore routingRuleStore;

    @Inject
    public ProxyRepositoryApiRequestToConfigurationConverter(RoutingRuleStore routingRuleStore) {
        this.routingRuleStore = routingRuleStore;
    }

    @Override
    public Configuration convert(T request) {
        Configuration configuration = super.convert(request);
        this.convertRoutingRule(request, configuration);
        this.convertStorage(request, configuration);
        this.convertCleanup(request, configuration);
        this.convertProxy(request, configuration);
        this.convertNegativeCache(request, configuration);
        this.convertHttpClient(request, configuration);
        this.convertReplication(request, configuration);
        return configuration;
    }

    private void convertHttpClient(T request, Configuration configuration) {
        HttpClientAttributes httpClient = ((ProxyRepositoryApiRequest)request).getHttpClient();
        if (Objects.nonNull(httpClient)) {
            NestedAttributesMap httpClientConfiguration = configuration.attributes("httpclient");
            httpClientConfiguration.set("blocked", (Object)httpClient.getBlocked());
            httpClientConfiguration.set("autoBlock", (Object)httpClient.getAutoBlock());
            HttpClientConnectionAttributes connection = httpClient.getConnection();
            NestedAttributesMap connectionConfiguration = httpClientConfiguration.child("connection");
            this.convertConnection(connection, connectionConfiguration, ((ProxyRepositoryApiRequest)request).getProxy().getRemoteUrl().startsWith("https"));
            this.convertAuthentication(httpClient, httpClientConfiguration);
        }
    }

    private void convertAuthentication(HttpClientAttributes httpClient, NestedAttributesMap httpClientConfiguration) {
        HttpClientConnectionAuthenticationAttributes authentication = httpClient.getAuthentication();
        if (Objects.nonNull(authentication)) {
            NestedAttributesMap authenticationConfiguration = httpClientConfiguration.child("authentication");
            authenticationConfiguration.set("type", (Object)authentication.getType());
            authenticationConfiguration.set("username", (Object)authentication.getUsername());
            authenticationConfiguration.set("password", (Object)authentication.getPassword());
            authenticationConfiguration.set("ntlmHost", (Object)authentication.getNtlmHost());
            authenticationConfiguration.set("ntlmDomain", (Object)authentication.getNtlmDomain());
        }
    }

    private void convertConnection(HttpClientConnectionAttributes connection, NestedAttributesMap connectionConfiguration, boolean isHttps) {
        if (Objects.nonNull(connection)) {
            if (Boolean.TRUE.equals(connection.getUseTrustStore()) && !isHttps) {
                throw new IllegalArgumentException("TrustStore is available only with HTTPS remote URLs");
            }
            connectionConfiguration.set("retries", (Object)connection.getRetries());
            connectionConfiguration.set("userAgentSuffix", (Object)connection.getUserAgentSuffix());
            connectionConfiguration.set("timeout", (Object)connection.getTimeout());
            connectionConfiguration.set("enableCircularRedirects", (Object)connection.getEnableCircularRedirects());
            connectionConfiguration.set("enableCookies", (Object)connection.getEnableCookies());
            connectionConfiguration.set("useTrustStore", (Object)connection.getUseTrustStore());
        }
    }

    private void convertNegativeCache(T request, Configuration configuration) {
        NegativeCacheAttributes negativeCache = ((ProxyRepositoryApiRequest)request).getNegativeCache();
        if (Objects.nonNull(negativeCache)) {
            NestedAttributesMap negativeCacheConfiguration = configuration.attributes("negativeCache");
            negativeCacheConfiguration.set("enabled", (Object)negativeCache.getEnabled());
            negativeCacheConfiguration.set("timeToLive", (Object)negativeCache.getTimeToLive());
        }
    }

    private void convertProxy(T request, Configuration configuration) {
        ProxyAttributes proxy = ((ProxyRepositoryApiRequest)request).getProxy();
        if (Objects.nonNull(proxy)) {
            NestedAttributesMap proxyConfiguration = configuration.attributes("proxy");
            proxyConfiguration.set("remoteUrl", (Object)proxy.getRemoteUrl());
            proxyConfiguration.set("contentMaxAge", (Object)proxy.getContentMaxAge());
            proxyConfiguration.set("metadataMaxAge", (Object)proxy.getMetadataMaxAge());
        }
    }

    private void convertCleanup(T request, Configuration configuration) {
        CleanupPolicyAttributes cleanup = ((ProxyRepositoryApiRequest)request).getCleanup();
        if (Objects.nonNull(cleanup)) {
            NestedAttributesMap cleanupConfiguration = configuration.attributes("cleanup");
            cleanupConfiguration.set("policyName", (Object)Sets.newHashSet(cleanup.getPolicyNames()));
        }
    }

    private void convertStorage(T request, Configuration configuration) {
        StorageAttributes storage = ((ProxyRepositoryApiRequest)request).getStorage();
        if (Objects.nonNull(storage)) {
            NestedAttributesMap storageConfiguration = configuration.attributes("storage");
            storageConfiguration.set("blobStoreName", (Object)storage.getBlobStoreName());
            storageConfiguration.set("strictContentTypeValidation", (Object)storage.getStrictContentTypeValidation());
            this.maybeAddDataStoreName(configuration);
        }
    }

    private void convertRoutingRule(T request, Configuration configuration) {
        RoutingRule routingRule;
        String routingRuleName = ((ProxyRepositoryApiRequest)request).getRoutingRule();
        if (!Strings2.isBlank((String)routingRuleName) && Objects.nonNull(routingRule = this.routingRuleStore.getByName(routingRuleName))) {
            configuration.setRoutingRuleId(routingRule.id());
        }
    }

    private void convertReplication(T request, Configuration configuration) {
        ReplicationAttributes replication = ((ProxyRepositoryApiRequest)request).getReplication();
        if (Objects.nonNull(replication)) {
            NestedAttributesMap replicationConfiguration = configuration.attributes("replication");
            replicationConfiguration.set("preemptivePullEnabled", (Object)replication.getPreemptivePullEnabled());
            replicationConfiguration.set("assetPathRegex", (Object)replication.getAssetPathRegex());
        }
    }
}

