/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.api;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.sonatype.nexus.rest.WebApplicationMessageException;

public class FormatAndType {
    private static final Pattern GET_REPO_PATH = Pattern.compile(".+/(.+)/(hosted|group|proxy)/(?!/).+");
    private String format;
    private String type;

    @Context
    public void setUriInfo(UriInfo uriInfo) {
        Matcher matcher = GET_REPO_PATH.matcher(uriInfo.getPath());
        if (!matcher.matches()) {
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)"\"Repository not found\"", "application/json");
        }
        this.format = "maven".equals(matcher.group(1)) ? "maven2" : matcher.group(1);
        this.type = matcher.group(2);
    }

    public String type() {
        return this.type;
    }

    public String format() {
        return this.format;
    }
}

