/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.api;

import com.google.common.base.Preconditions;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.rest.api.ComponentXO;
import org.sonatype.nexus.repository.rest.api.ComponentXODecorator;
import org.sonatype.nexus.repository.rest.api.DefaultComponentXO;

@Singleton
@Named
public class ComponentXOFactory {
    private final Set<ComponentXODecorator> componentXODecorators;

    @Inject
    public ComponentXOFactory(Set<ComponentXODecorator> componentXODecorators) {
        this.componentXODecorators = (Set)Preconditions.checkNotNull(componentXODecorators);
    }

    public ComponentXO createComponentXO() {
        ComponentXO componentXO = new DefaultComponentXO();
        for (ComponentXODecorator componentXODecorator : this.componentXODecorators) {
            componentXO = componentXODecorator.decorate(componentXO);
        }
        return componentXO;
    }
}

