/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.api;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Set;
import org.sonatype.nexus.repository.rest.api.ComponentXO;
import org.sonatype.nexus.repository.rest.api.ComponentXODeserializerExtension;
import org.sonatype.nexus.repository.rest.api.ComponentXOFactory;

public class ComponentXODeserializer
extends JsonDeserializer<ComponentXO> {
    private final ComponentXOFactory componentXOFactory;
    private final ObjectMapper objectMapper;
    private final Set<ComponentXODeserializerExtension> componentXODeserializerExtensions;

    public ComponentXODeserializer(ComponentXOFactory componentXOFactory, ObjectMapper objectMapper, Set<ComponentXODeserializerExtension> componentXODeserializerExtensions) {
        this.componentXOFactory = (ComponentXOFactory)Preconditions.checkNotNull((Object)componentXOFactory);
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
        this.componentXODeserializerExtensions = (Set)Preconditions.checkNotNull(componentXODeserializerExtensions);
    }

    public ComponentXO deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        ComponentXO componentXO = this.componentXOFactory.createComponentXO();
        this.objectMapper.readerForUpdating((Object)componentXO).readValue(jsonNode);
        for (ComponentXODeserializerExtension componentXODeserializerExtension : this.componentXODeserializerExtensions) {
            componentXO = componentXODeserializerExtension.updateComponentXO(componentXO, jsonNode);
        }
        return componentXO;
    }
}

