/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.api;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.ToString;
import groovy.transform.builder.Builder;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.util.HashCodeHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.api.AssetXODescriptor;
import org.sonatype.nexus.repository.rest.api.RepositoryItemIDXO;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.index.SearchConstants;

@Builder
@ToString(includeNames=true, includePackage=false)
@EqualsAndHashCode(includes={"id"})
public class AssetXO
implements GroovyObject {
    private String downloadUrl;
    private String path;
    private String id;
    private String repository;
    private String format;
    private Map checksum;
    private String contentType;
    private Date lastModified;
    private Date lastDownloaded;
    private String uploader;
    private String uploaderIp;
    private long fileSize;
    @JsonIgnore
    private Map attributes;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public AssetXO() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static AssetXO from(AssetSearchResult asset, Repository repository, @Nullable Map<String, AssetXODescriptor> assetDescriptors) {
        return AssetXO.builder().path(asset.getPath()).downloadUrl(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)repository.getUrl(), (CharSequence)"/"), (CharSequence)asset.getPath())).id(new RepositoryItemIDXO(repository.getName(), asset.getId()).getValue()).repository(repository.getName()).checksum(asset.getChecksum()).format(asset.getFormat()).contentType(asset.getContentType()).attributes(AssetXO.getExpandedAttributes(asset.getAttributes(), asset.getFormat(), assetDescriptors)).lastModified(asset.getLastModified()).uploader(asset.getUploader()).uploaderIp(asset.getUploaderIp()).build();
    }

    public static AssetXO fromElasticSearchMap(Map map, Repository repository, @Nullable Map<String, AssetXODescriptor> assetDescriptors) {
        String path = ShortTypeHandling.castToString(map.get(SearchConstants.NAME));
        String id = ShortTypeHandling.castToString(map.get(SearchConstants.ID));
        Map attributes = (Map)DefaultGroovyMethods.get((Map)map, (Object)SearchConstants.ATTRIBUTES, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        Map checksum = (Map)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)attributes, (Object)SearchConstants.CHECKSUM), Map.class);
        String format = repository.getFormat().getValue();
        String contentType = ShortTypeHandling.castToString(map.get(SearchConstants.CONTENT_TYPE));
        return AssetXO.builder().path(path).downloadUrl(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)repository.getUrl(), (CharSequence)"/"), (CharSequence)path)).id(new RepositoryItemIDXO(repository.getName(), id).getValue()).repository(repository.getName()).checksum(checksum).format(format).contentType(contentType).attributes(AssetXO.getExpandedAttributes(attributes, format, assetDescriptors)).lastModified(AssetXO.calculateLastModified(attributes)).build();
    }

    private static final Map getExpandedAttributes(Map attributes, String format, @Nullable Map<String, AssetXODescriptor> assetDescriptors) {
        Map<String, AssetXODescriptor> map = assetDescriptors;
        AssetXODescriptor assetXODescriptor = map != null ? map.get(format) : null;
        Set<String> exposedAttributeKeys = assetXODescriptor != null ? assetXODescriptor.listExposedAttributeKeys() : null;
        LinkedHashMap expanded = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        if (DefaultTypeTransformation.booleanUnbox(exposedAttributeKeys)) {
            Map map2 = (Map)DefaultGroovyMethods.get((Map)attributes, (Object)format, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
            Map exposedAttributes = map2 != null ? DefaultGroovyMethods.subMap((Map)map2, exposedAttributeKeys) : null;
            if (DefaultTypeTransformation.booleanUnbox((Object)exposedAttributes)) {
                expanded.put(format, exposedAttributes);
            }
        }
        return expanded;
    }

    private static final Date calculateLastModified(Map attributes) {
        String lastModifiedString = ShortTypeHandling.castToString(((Map)ScriptBytecodeAdapter.asType((Object)attributes.getOrDefault("content", ScriptBytecodeAdapter.createMap((Object[])new Object[0])), Map.class)).getOrDefault("last_modified", null));
        Date lastModified = null;
        if (lastModifiedString != null) {
            try {
                Date date;
                lastModified = date = new Date(Long.parseLong(lastModifiedString.trim()));
            }
            catch (Exception ignored) {
            }
        }
        return lastModified;
    }

    @JsonAnyGetter
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public static AssetXOBuilder builder() {
        return new AssetXOBuilder();
    }

    public String toString() {
        StringBuilder _result = new StringBuilder();
        Boolean $toStringFirst = Boolean.TRUE;
        _result.append("AssetXO(");
        Boolean bl = $toStringFirst;
        if (bl == null ? false : bl) {
            Boolean bl2;
            $toStringFirst = bl2 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("downloadUrl:");
        if (this.getDownloadUrl() == this) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString((Object)this.getDownloadUrl()));
        }
        Boolean bl3 = $toStringFirst;
        if (bl3 == null ? false : bl3) {
            Boolean bl4;
            $toStringFirst = bl4 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("path:");
        if (this.getPath() == this) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString((Object)this.getPath()));
        }
        Boolean bl5 = $toStringFirst;
        if (bl5 == null ? false : bl5) {
            Boolean bl6;
            $toStringFirst = bl6 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("id:");
        if (this.getId() == this) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString((Object)this.getId()));
        }
        Boolean bl7 = $toStringFirst;
        if (bl7 == null ? false : bl7) {
            Boolean bl8;
            $toStringFirst = bl8 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("repository:");
        if (this.getRepository() == this) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString((Object)this.getRepository()));
        }
        Boolean bl9 = $toStringFirst;
        if (bl9 == null ? false : bl9) {
            Boolean bl10;
            $toStringFirst = bl10 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("format:");
        if (this.getFormat() == this) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString((Object)this.getFormat()));
        }
        Boolean bl11 = $toStringFirst;
        if (bl11 == null ? false : bl11) {
            Boolean bl12;
            $toStringFirst = bl12 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("checksum:");
        if (this.getChecksum() == this) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString((Object)this.getChecksum()));
        }
        Boolean bl13 = $toStringFirst;
        if (bl13 == null ? false : bl13) {
            Boolean bl14;
            $toStringFirst = bl14 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("contentType:");
        if (this.getContentType() == this) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString((Object)this.getContentType()));
        }
        Boolean bl15 = $toStringFirst;
        if (bl15 == null ? false : bl15) {
            Boolean bl16;
            $toStringFirst = bl16 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("lastModified:");
        if (this.getLastModified() == this) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString((Object)this.getLastModified()));
        }
        Boolean bl17 = $toStringFirst;
        if (bl17 == null ? false : bl17) {
            Boolean bl18;
            $toStringFirst = bl18 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("lastDownloaded:");
        if (this.getLastDownloaded() == this) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString((Object)this.getLastDownloaded()));
        }
        Boolean bl19 = $toStringFirst;
        if (bl19 == null ? false : bl19) {
            Boolean bl20;
            $toStringFirst = bl20 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("uploader:");
        if (this.getUploader() == this) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString((Object)this.getUploader()));
        }
        Boolean bl21 = $toStringFirst;
        if (bl21 == null ? false : bl21) {
            Boolean bl22;
            $toStringFirst = bl22 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("uploaderIp:");
        if (this.getUploaderIp() == this) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString((Object)this.getUploaderIp()));
        }
        Boolean bl23 = $toStringFirst;
        if (bl23 == null ? false : bl23) {
            Boolean bl24;
            $toStringFirst = bl24 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("fileSize:");
        if (Long.valueOf(this.getFileSize()) == this) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString((Object)this.getFileSize()));
        }
        Boolean bl25 = $toStringFirst;
        if (bl25 == null ? false : bl25) {
            Boolean bl26;
            $toStringFirst = bl26 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("attributes:");
        if (this.getAttributes() == this) {
            _result.append("(this)");
        } else {
            _result.append(InvokerHelper.toString(this.getAttributes()));
        }
        _result.append(")");
        return _result.toString();
    }

    public int hashCode() {
        int _result = HashCodeHelper.initHash();
        if (!(this.getId() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.getId());
        }
        return _result;
    }

    public boolean canEqual(Object other) {
        return other instanceof AssetXO;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof AssetXO)) {
            return false;
        }
        AssetXO otherTyped = (AssetXO)other;
        if (!otherTyped.canEqual(this)) {
            return false;
        }
        return !(!ScriptBytecodeAdapter.compareEqual((Object)this.getId(), (Object)otherTyped.getId()));
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AssetXO.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AssetXO.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AssetXO.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ String pfaccess$0(AssetXO $that) {
        return $that.getDownloadUrl();
    }

    public static /* synthetic */ String pfaccess$1(AssetXO $that) {
        return $that.getPath();
    }

    public static /* synthetic */ String pfaccess$2(AssetXO $that) {
        return $that.getId();
    }

    public static /* synthetic */ String pfaccess$3(AssetXO $that) {
        return $that.getRepository();
    }

    public static /* synthetic */ String pfaccess$4(AssetXO $that) {
        return $that.getFormat();
    }

    public static /* synthetic */ Map pfaccess$5(AssetXO $that) {
        return $that.getChecksum();
    }

    public static /* synthetic */ String pfaccess$6(AssetXO $that) {
        return $that.getContentType();
    }

    public static /* synthetic */ Date pfaccess$7(AssetXO $that) {
        return $that.getLastModified();
    }

    public static /* synthetic */ Date pfaccess$8(AssetXO $that) {
        return $that.getLastDownloaded();
    }

    public static /* synthetic */ String pfaccess$9(AssetXO $that) {
        return $that.getUploader();
    }

    public static /* synthetic */ String pfaccess$10(AssetXO $that) {
        return $that.getUploaderIp();
    }

    public static /* synthetic */ long pfaccess$11(AssetXO $that) {
        return $that.getFileSize();
    }

    public static /* synthetic */ Map pfaccess$12(AssetXO $that) {
        return $that.getAttributes();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AssetXO.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String string) {
        this.downloadUrl = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String string) {
        this.repository = string;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public Map getChecksum() {
        return this.checksum;
    }

    public void setChecksum(Map map) {
        this.checksum = map;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date date) {
        this.lastModified = date;
    }

    public Date getLastDownloaded() {
        return this.lastDownloaded;
    }

    public void setLastDownloaded(Date date) {
        this.lastDownloaded = date;
    }

    public String getUploader() {
        return this.uploader;
    }

    public void setUploader(String string) {
        this.uploader = string;
    }

    public String getUploaderIp() {
        return this.uploaderIp;
    }

    public void setUploaderIp(String string) {
        this.uploaderIp = string;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long l) {
        this.fileSize = l;
    }

    public void setAttributes(Map map) {
        this.attributes = map;
    }

    public static class AssetXOBuilder
    implements GroovyObject {
        private String downloadUrl;
        private String path;
        private String id;
        private String repository;
        private String format;
        private Map checksum;
        private String contentType;
        private Date lastModified;
        private Date lastDownloaded;
        private String uploader;
        private String uploaderIp;
        private long fileSize;
        private Map attributes;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public AssetXOBuilder() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public AssetXOBuilder downloadUrl(String downloadUrl) {
            String string;
            this.downloadUrl = string = downloadUrl;
            return this;
        }

        public AssetXOBuilder path(String path) {
            String string;
            this.path = string = path;
            return this;
        }

        public AssetXOBuilder id(String id) {
            String string;
            this.id = string = id;
            return this;
        }

        public AssetXOBuilder repository(String repository) {
            String string;
            this.repository = string = repository;
            return this;
        }

        public AssetXOBuilder format(String format) {
            String string;
            this.format = string = format;
            return this;
        }

        public AssetXOBuilder checksum(Map checksum) {
            Map map;
            this.checksum = map = checksum;
            return this;
        }

        public AssetXOBuilder contentType(String contentType) {
            String string;
            this.contentType = string = contentType;
            return this;
        }

        public AssetXOBuilder lastModified(Date lastModified) {
            Date date;
            this.lastModified = date = lastModified;
            return this;
        }

        public AssetXOBuilder lastDownloaded(Date lastDownloaded) {
            Date date;
            this.lastDownloaded = date = lastDownloaded;
            return this;
        }

        public AssetXOBuilder uploader(String uploader) {
            String string;
            this.uploader = string = uploader;
            return this;
        }

        public AssetXOBuilder uploaderIp(String uploaderIp) {
            String string;
            this.uploaderIp = string = uploaderIp;
            return this;
        }

        public AssetXOBuilder fileSize(long fileSize) {
            long l = fileSize;
            this.fileSize = l;
            return this;
        }

        public AssetXOBuilder attributes(Map attributes) {
            Map map;
            this.attributes = map = attributes;
            return this;
        }

        public AssetXO build() {
            AssetXO _theAssetXO = new AssetXO();
            String string = this.downloadUrl;
            _theAssetXO.setDownloadUrl(string);
            String string2 = this.path;
            _theAssetXO.setPath(string2);
            String string3 = this.id;
            _theAssetXO.setId(string3);
            String string4 = this.repository;
            _theAssetXO.setRepository(string4);
            String string5 = this.format;
            _theAssetXO.setFormat(string5);
            Map map = this.checksum;
            _theAssetXO.setChecksum(map);
            String string6 = this.contentType;
            _theAssetXO.setContentType(string6);
            Date date = this.lastModified;
            _theAssetXO.setLastModified(date);
            Date date2 = this.lastDownloaded;
            _theAssetXO.setLastDownloaded(date2);
            String string7 = this.uploader;
            _theAssetXO.setUploader(string7);
            String string8 = this.uploaderIp;
            _theAssetXO.setUploaderIp(string8);
            long l = this.fileSize;
            _theAssetXO.setFileSize(l);
            Map map2 = this.attributes;
            _theAssetXO.setAttributes(map2);
            return _theAssetXO;
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(AssetXOBuilder.class, AssetXO.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(AssetXOBuilder.class, AssetXO.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AssetXO.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AssetXO.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(AssetXOBuilder.class, AssetXO.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(AssetXOBuilder.class, AssetXO.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AssetXOBuilder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

