/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.api;

import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationStore;
import org.sonatype.nexus.repository.rest.api.model.AbstractRepositoryApiRequest;

public abstract class AbstractRepositoryApiRequestToConfigurationConverter<T extends AbstractRepositoryApiRequest> {
    @Inject
    protected ConfigurationStore configurationStore;
    @Named(value="nexus.orient.enabled")
    @Inject
    protected boolean orientEnabled;

    protected void maybeAddDataStoreName(Configuration configuration) {
        if (!this.orientEnabled) {
            configuration.attributes("storage").set("dataStoreName", (Object)"nexus");
        }
    }

    public Configuration convert(T request) {
        Configuration configuration = this.configurationStore.newConfiguration();
        configuration.setRepositoryName(((AbstractRepositoryApiRequest)request).getName());
        configuration.setRecipeName(String.join((CharSequence)"-", ((AbstractRepositoryApiRequest)request).getFormat(), ((AbstractRepositoryApiRequest)request).getType()));
        configuration.setOnline(((AbstractRepositoryApiRequest)request).getOnline().booleanValue());
        return configuration;
    }
}

